<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for movimentoBean StructType
 * @subpackage Structs
 */
class MovimentoBean extends AbstractStructBase
{
    /**
     * The arrivi
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \ArrayType\ArrayOfArrivoBean
     */
    public $arrivi;
    /**
     * The partenze
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \ArrayType\ArrayOfPartenzaBean
     */
    public $partenze;
    /**
     * The prenotazioni
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \ArrayType\ArrayOfPrenotazioneBean
     */
    public $prenotazioni;
    /**
     * The rettifiche
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \StructType\Rettifiche
     */
    public $rettifiche;
    /**
     * The data
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $data;
    /**
     * The struttura
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\StrutturaBean
     */
    public $struttura;
    /**
     * Constructor method for movimentoBean
     * @uses MovimentoBean::setArrivi()
     * @uses MovimentoBean::setPartenze()
     * @uses MovimentoBean::setPrenotazioni()
     * @uses MovimentoBean::setRettifiche()
     * @uses MovimentoBean::setData()
     * @uses MovimentoBean::setStruttura()
     * @param \ArrayType\ArrayOfArrivoBean $arrivi
     * @param \ArrayType\ArrayOfPartenzaBean $partenze
     * @param \ArrayType\ArrayOfPrenotazioneBean $prenotazioni
     * @param \StructType\Rettifiche $rettifiche
     * @param string $data
     * @param \StructType\StrutturaBean $struttura
     */
    public function __construct(\ArrayType\ArrayOfArrivoBean $arrivi = null, \ArrayType\ArrayOfPartenzaBean $partenze = null, \ArrayType\ArrayOfPrenotazioneBean $prenotazioni = null, \StructType\Rettifiche $rettifiche = null, $data = null, \StructType\StrutturaBean $struttura = null)
    {
        $this
            ->setArrivi($arrivi)
            ->setPartenze($partenze)
            ->setPrenotazioni($prenotazioni)
            ->setRettifiche($rettifiche)
            ->setData($data)
            ->setStruttura($struttura);
    }
    /**
     * Get arrivi value
     * @return \ArrayType\ArrayOfArrivoBean
     */
    public function getArrivi()
    {
        return $this->arrivi;
    }
    /**
     * Set arrivi value
     * @param \ArrayType\ArrayOfArrivoBean $arrivi
     * @return \StructType\MovimentoBean
     */
    public function setArrivi(\ArrayType\ArrayOfArrivoBean $arrivi = null)
    {
        $this->arrivi = $arrivi;
        return $this;
    }
    /**
     * Get partenze value
     * @return \ArrayType\ArrayOfPartenzaBean
     */
    public function getPartenze()
    {
        return $this->partenze;
    }
    /**
     * Set partenze value
     * @param \ArrayType\ArrayOfPartenzaBean $partenze
     * @return \StructType\MovimentoBean
     */
    public function setPartenze(\ArrayType\ArrayOfPartenzaBean $partenze = null)
    {
        $this->partenze = $partenze;
        return $this;
    }
    /**
     * Get prenotazioni value
     * @return \ArrayType\ArrayOfPrenotazioneBean
     */
    public function getPrenotazioni()
    {
        return $this->prenotazioni;
    }
    /**
     * Set prenotazioni value
     * @param \ArrayType\ArrayOfPrenotazioneBean $prenotazioni
     * @return \StructType\MovimentoBean
     */
    public function setPrenotazioni(\ArrayType\ArrayOfPrenotazioneBean $prenotazioni = null)
    {
        $this->prenotazioni = $prenotazioni;
        return $this;
    }
    /**
     * Get rettifiche value
     * @return \StructType\Rettifiche
     */
    public function getRettifiche()
    {
        return $this->rettifiche;
    }
    /**
     * Set rettifiche value
     * @param \StructType\Rettifiche $rettifiche
     * @return \StructType\MovimentoBean
     */
    public function setRettifiche(\StructType\Rettifiche $rettifiche = null)
    {
        $this->rettifiche = $rettifiche;
        return $this;
    }
    /**
     * Get data value
     * @return string|null
     */
    public function getData()
    {
        return $this->data;
    }
    /**
     * Set data value
     * @param string $data
     * @return \StructType\MovimentoBean
     */
    public function setData($data = null)
    {
        // validation for constraint: string
        if (!is_null($data) && !is_string($data)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($data, true), gettype($data)), __LINE__);
        }
        $this->data = $data;
        return $this;
    }
    /**
     * Get struttura value
     * @return \StructType\StrutturaBean|null
     */
    public function getStruttura()
    {
        return $this->struttura;
    }
    /**
     * Set struttura value
     * @param \StructType\StrutturaBean $struttura
     * @return \StructType\MovimentoBean
     */
    public function setStruttura(\StructType\StrutturaBean $struttura = null)
    {
        $this->struttura = $struttura;
        return $this;
    }
}
