<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DatiSalientiMensile StructType
 * @subpackage Structs
 */
class DatiSalientiMensile extends AbstractStructBase
{
    /**
     * The DataCalendario
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DataCalendario;
    /**
     * The Presenze
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Presenze;
    /**
     * The Arrivi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Arrivi;
    /**
     * The Notte
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Notte;
    /**
     * The Partenze
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Partenze;
    /**
     * The DataInvio
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $DataInvio;
    /**
     * The NcamereOccupate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $NcamereOccupate;
    /**
     * The NpostiLetto
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $NpostiLetto;
    /**
     * The bEditRow
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $bEditRow;
    /**
     * The MotivoNonInviabile
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MotivoNonInviabile;
    /**
     * Constructor method for DatiSalientiMensile
     * @uses DatiSalientiMensile::setDataCalendario()
     * @uses DatiSalientiMensile::setPresenze()
     * @uses DatiSalientiMensile::setArrivi()
     * @uses DatiSalientiMensile::setNotte()
     * @uses DatiSalientiMensile::setPartenze()
     * @uses DatiSalientiMensile::setDataInvio()
     * @uses DatiSalientiMensile::setNcamereOccupate()
     * @uses DatiSalientiMensile::setNpostiLetto()
     * @uses DatiSalientiMensile::setBEditRow()
     * @uses DatiSalientiMensile::setMotivoNonInviabile()
     * @param string $dataCalendario
     * @param int $presenze
     * @param int $arrivi
     * @param int $notte
     * @param int $partenze
     * @param string $dataInvio
     * @param int $ncamereOccupate
     * @param int $npostiLetto
     * @param int $bEditRow
     * @param string $motivoNonInviabile
     */
    public function __construct($dataCalendario = null, $presenze = null, $arrivi = null, $notte = null, $partenze = null, $dataInvio = null, $ncamereOccupate = null, $npostiLetto = null, $bEditRow = null, $motivoNonInviabile = null)
    {
        $this
            ->setDataCalendario($dataCalendario)
            ->setPresenze($presenze)
            ->setArrivi($arrivi)
            ->setNotte($notte)
            ->setPartenze($partenze)
            ->setDataInvio($dataInvio)
            ->setNcamereOccupate($ncamereOccupate)
            ->setNpostiLetto($npostiLetto)
            ->setBEditRow($bEditRow)
            ->setMotivoNonInviabile($motivoNonInviabile);
    }
    /**
     * Get DataCalendario value
     * @return string
     */
    public function getDataCalendario()
    {
        return $this->DataCalendario;
    }
    /**
     * Set DataCalendario value
     * @param string $dataCalendario
     * @return \StructType\DatiSalientiMensile
     */
    public function setDataCalendario($dataCalendario = null)
    {
        // validation for constraint: string
        if (!is_null($dataCalendario) && !is_string($dataCalendario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataCalendario, true), gettype($dataCalendario)), __LINE__);
        }
        $this->DataCalendario = $dataCalendario;
        return $this;
    }
    /**
     * Get Presenze value
     * @return int
     */
    public function getPresenze()
    {
        return $this->Presenze;
    }
    /**
     * Set Presenze value
     * @param int $presenze
     * @return \StructType\DatiSalientiMensile
     */
    public function setPresenze($presenze = null)
    {
        // validation for constraint: int
        if (!is_null($presenze) && !(is_int($presenze) || ctype_digit($presenze))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($presenze, true), gettype($presenze)), __LINE__);
        }
        $this->Presenze = $presenze;
        return $this;
    }
    /**
     * Get Arrivi value
     * @return int
     */
    public function getArrivi()
    {
        return $this->Arrivi;
    }
    /**
     * Set Arrivi value
     * @param int $arrivi
     * @return \StructType\DatiSalientiMensile
     */
    public function setArrivi($arrivi = null)
    {
        // validation for constraint: int
        if (!is_null($arrivi) && !(is_int($arrivi) || ctype_digit($arrivi))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($arrivi, true), gettype($arrivi)), __LINE__);
        }
        $this->Arrivi = $arrivi;
        return $this;
    }
    /**
     * Get Notte value
     * @return int
     */
    public function getNotte()
    {
        return $this->Notte;
    }
    /**
     * Set Notte value
     * @param int $notte
     * @return \StructType\DatiSalientiMensile
     */
    public function setNotte($notte = null)
    {
        // validation for constraint: int
        if (!is_null($notte) && !(is_int($notte) || ctype_digit($notte))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($notte, true), gettype($notte)), __LINE__);
        }
        $this->Notte = $notte;
        return $this;
    }
    /**
     * Get Partenze value
     * @return int
     */
    public function getPartenze()
    {
        return $this->Partenze;
    }
    /**
     * Set Partenze value
     * @param int $partenze
     * @return \StructType\DatiSalientiMensile
     */
    public function setPartenze($partenze = null)
    {
        // validation for constraint: int
        if (!is_null($partenze) && !(is_int($partenze) || ctype_digit($partenze))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($partenze, true), gettype($partenze)), __LINE__);
        }
        $this->Partenze = $partenze;
        return $this;
    }
    /**
     * Get DataInvio value
     * @return string
     */
    public function getDataInvio()
    {
        return $this->DataInvio;
    }
    /**
     * Set DataInvio value
     * @param string $dataInvio
     * @return \StructType\DatiSalientiMensile
     */
    public function setDataInvio($dataInvio = null)
    {
        // validation for constraint: string
        if (!is_null($dataInvio) && !is_string($dataInvio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataInvio, true), gettype($dataInvio)), __LINE__);
        }
        $this->DataInvio = $dataInvio;
        return $this;
    }
    /**
     * Get NcamereOccupate value
     * @return int
     */
    public function getNcamereOccupate()
    {
        return $this->NcamereOccupate;
    }
    /**
     * Set NcamereOccupate value
     * @param int $ncamereOccupate
     * @return \StructType\DatiSalientiMensile
     */
    public function setNcamereOccupate($ncamereOccupate = null)
    {
        // validation for constraint: int
        if (!is_null($ncamereOccupate) && !(is_int($ncamereOccupate) || ctype_digit($ncamereOccupate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ncamereOccupate, true), gettype($ncamereOccupate)), __LINE__);
        }
        $this->NcamereOccupate = $ncamereOccupate;
        return $this;
    }
    /**
     * Get NpostiLetto value
     * @return int
     */
    public function getNpostiLetto()
    {
        return $this->NpostiLetto;
    }
    /**
     * Set NpostiLetto value
     * @param int $npostiLetto
     * @return \StructType\DatiSalientiMensile
     */
    public function setNpostiLetto($npostiLetto = null)
    {
        // validation for constraint: int
        if (!is_null($npostiLetto) && !(is_int($npostiLetto) || ctype_digit($npostiLetto))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($npostiLetto, true), gettype($npostiLetto)), __LINE__);
        }
        $this->NpostiLetto = $npostiLetto;
        return $this;
    }
    /**
     * Get bEditRow value
     * @return int
     */
    public function getBEditRow()
    {
        return $this->bEditRow;
    }
    /**
     * Set bEditRow value
     * @param int $bEditRow
     * @return \StructType\DatiSalientiMensile
     */
    public function setBEditRow($bEditRow = null)
    {
        // validation for constraint: int
        if (!is_null($bEditRow) && !(is_int($bEditRow) || ctype_digit($bEditRow))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($bEditRow, true), gettype($bEditRow)), __LINE__);
        }
        $this->bEditRow = $bEditRow;
        return $this;
    }
    /**
     * Get MotivoNonInviabile value
     * @return string|null
     */
    public function getMotivoNonInviabile()
    {
        return $this->MotivoNonInviabile;
    }
    /**
     * Set MotivoNonInviabile value
     * @param string $motivoNonInviabile
     * @return \StructType\DatiSalientiMensile
     */
    public function setMotivoNonInviabile($motivoNonInviabile = null)
    {
        // validation for constraint: string
        if (!is_null($motivoNonInviabile) && !is_string($motivoNonInviabile)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($motivoNonInviabile, true), gettype($motivoNonInviabile)), __LINE__);
        }
        $this->MotivoNonInviabile = $motivoNonInviabile;
        return $this;
    }
}
