<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ImportShipmentReturnImageResponse StructType
 * @subpackage Structs
 */
class ImportShipmentReturnImageResponse extends AbstractStructBase
{
    /**
     * The ImportShipmentReturnImageResult
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfColloRow
     */
    public $ImportShipmentReturnImageResult;
    /**
     * The imageData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $imageData;
    /**
     * The shipmentDocuments
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $shipmentDocuments;
    /**
     * The errorCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $errorCode;
    /**
     * The errorMessage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $errorMessage;
    /**
     * Constructor method for ImportShipmentReturnImageResponse
     * @uses ImportShipmentReturnImageResponse::setImportShipmentReturnImageResult()
     * @uses ImportShipmentReturnImageResponse::setImageData()
     * @uses ImportShipmentReturnImageResponse::setShipmentDocuments()
     * @uses ImportShipmentReturnImageResponse::setErrorCode()
     * @uses ImportShipmentReturnImageResponse::setErrorMessage()
     * @param \ArrayType\ArrayOfColloRow $importShipmentReturnImageResult
     * @param \ArrayType\ArrayOfstring $imageData
     * @param string $shipmentDocuments
     * @param string $errorCode
     * @param string $errorMessage
     */
    public function __construct(\ArrayType\ArrayOfColloRow $importShipmentReturnImageResult = null, \ArrayType\ArrayOfstring $imageData = null, $shipmentDocuments = null, $errorCode = null, $errorMessage = null)
    {
        $this
            ->setImportShipmentReturnImageResult($importShipmentReturnImageResult)
            ->setImageData($imageData)
            ->setShipmentDocuments($shipmentDocuments)
            ->setErrorCode($errorCode)
            ->setErrorMessage($errorMessage);
    }
    /**
     * Get ImportShipmentReturnImageResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfColloRow|null
     */
    public function getImportShipmentReturnImageResult()
    {
        return isset($this->ImportShipmentReturnImageResult) ? $this->ImportShipmentReturnImageResult : null;
    }
    /**
     * Set ImportShipmentReturnImageResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfColloRow $importShipmentReturnImageResult
     * @return \StructType\ImportShipmentReturnImageResponse
     */
    public function setImportShipmentReturnImageResult(\ArrayType\ArrayOfColloRow $importShipmentReturnImageResult = null)
    {
        if (is_null($importShipmentReturnImageResult) || (is_array($importShipmentReturnImageResult) && empty($importShipmentReturnImageResult))) {
            unset($this->ImportShipmentReturnImageResult);
        } else {
            $this->ImportShipmentReturnImageResult = $importShipmentReturnImageResult;
        }
        return $this;
    }
    /**
     * Get imageData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getImageData()
    {
        return isset($this->imageData) ? $this->imageData : null;
    }
    /**
     * Set imageData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfstring $imageData
     * @return \StructType\ImportShipmentReturnImageResponse
     */
    public function setImageData(\ArrayType\ArrayOfstring $imageData = null)
    {
        if (is_null($imageData) || (is_array($imageData) && empty($imageData))) {
            unset($this->imageData);
        } else {
            $this->imageData = $imageData;
        }
        return $this;
    }
    /**
     * Get shipmentDocuments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getShipmentDocuments()
    {
        return isset($this->shipmentDocuments) ? $this->shipmentDocuments : null;
    }
    /**
     * Set shipmentDocuments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $shipmentDocuments
     * @return \StructType\ImportShipmentReturnImageResponse
     */
    public function setShipmentDocuments($shipmentDocuments = null)
    {
        // validation for constraint: string
        if (!is_null($shipmentDocuments) && !is_string($shipmentDocuments)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipmentDocuments, true), gettype($shipmentDocuments)), __LINE__);
        }
        if (is_null($shipmentDocuments) || (is_array($shipmentDocuments) && empty($shipmentDocuments))) {
            unset($this->shipmentDocuments);
        } else {
            $this->shipmentDocuments = $shipmentDocuments;
        }
        return $this;
    }
    /**
     * Get errorCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getErrorCode()
    {
        return isset($this->errorCode) ? $this->errorCode : null;
    }
    /**
     * Set errorCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $errorCode
     * @return \StructType\ImportShipmentReturnImageResponse
     */
    public function setErrorCode($errorCode = null)
    {
        // validation for constraint: string
        if (!is_null($errorCode) && !is_string($errorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorCode, true), gettype($errorCode)), __LINE__);
        }
        if (is_null($errorCode) || (is_array($errorCode) && empty($errorCode))) {
            unset($this->errorCode);
        } else {
            $this->errorCode = $errorCode;
        }
        return $this;
    }
    /**
     * Get errorMessage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getErrorMessage()
    {
        return isset($this->errorMessage) ? $this->errorMessage : null;
    }
    /**
     * Set errorMessage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $errorMessage
     * @return \StructType\ImportShipmentReturnImageResponse
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorMessage, true), gettype($errorMessage)), __LINE__);
        }
        if (is_null($errorMessage) || (is_array($errorMessage) && empty($errorMessage))) {
            unset($this->errorMessage);
        } else {
            $this->errorMessage = $errorMessage;
        }
        return $this;
    }
}
