<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ImportAddress StructType
 * @subpackage Structs
 */
class ImportAddress extends AbstractStructBase
{
    /**
     * The clientID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $clientID;
    /**
     * The orgUnitID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $orgUnitID;
    /**
     * The orgUnitGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $orgUnitGuid;
    /**
     * The addresses
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfAddressRow
     */
    public $addresses;
    /**
     * Constructor method for ImportAddress
     * @uses ImportAddress::setClientID()
     * @uses ImportAddress::setOrgUnitID()
     * @uses ImportAddress::setOrgUnitGuid()
     * @uses ImportAddress::setAddresses()
     * @param int $clientID
     * @param int $orgUnitID
     * @param string $orgUnitGuid
     * @param \ArrayType\ArrayOfAddressRow $addresses
     */
    public function __construct($clientID = null, $orgUnitID = null, $orgUnitGuid = null, \ArrayType\ArrayOfAddressRow $addresses = null)
    {
        $this
            ->setClientID($clientID)
            ->setOrgUnitID($orgUnitID)
            ->setOrgUnitGuid($orgUnitGuid)
            ->setAddresses($addresses);
    }
    /**
     * Get clientID value
     * @return int|null
     */
    public function getClientID()
    {
        return $this->clientID;
    }
    /**
     * Set clientID value
     * @param int $clientID
     * @return \StructType\ImportAddress
     */
    public function setClientID($clientID = null)
    {
        // validation for constraint: int
        if (!is_null($clientID) && !(is_int($clientID) || ctype_digit($clientID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($clientID, true), gettype($clientID)), __LINE__);
        }
        $this->clientID = $clientID;
        return $this;
    }
    /**
     * Get orgUnitID value
     * @return int|null
     */
    public function getOrgUnitID()
    {
        return $this->orgUnitID;
    }
    /**
     * Set orgUnitID value
     * @param int $orgUnitID
     * @return \StructType\ImportAddress
     */
    public function setOrgUnitID($orgUnitID = null)
    {
        // validation for constraint: int
        if (!is_null($orgUnitID) && !(is_int($orgUnitID) || ctype_digit($orgUnitID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($orgUnitID, true), gettype($orgUnitID)), __LINE__);
        }
        $this->orgUnitID = $orgUnitID;
        return $this;
    }
    /**
     * Get orgUnitGuid value
     * @return string|null
     */
    public function getOrgUnitGuid()
    {
        return $this->orgUnitGuid;
    }
    /**
     * Set orgUnitGuid value
     * @param string $orgUnitGuid
     * @return \StructType\ImportAddress
     */
    public function setOrgUnitGuid($orgUnitGuid = null)
    {
        // validation for constraint: string
        if (!is_null($orgUnitGuid) && !is_string($orgUnitGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orgUnitGuid, true), gettype($orgUnitGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($orgUnitGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $orgUnitGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($orgUnitGuid, true)), __LINE__);
        }
        $this->orgUnitGuid = $orgUnitGuid;
        return $this;
    }
    /**
     * Get addresses value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfAddressRow|null
     */
    public function getAddresses()
    {
        return isset($this->addresses) ? $this->addresses : null;
    }
    /**
     * Set addresses value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfAddressRow $addresses
     * @return \StructType\ImportAddress
     */
    public function setAddresses(\ArrayType\ArrayOfAddressRow $addresses = null)
    {
        if (is_null($addresses) || (is_array($addresses) && empty($addresses))) {
            unset($this->addresses);
        } else {
            $this->addresses = $addresses;
        }
        return $this;
    }
}
