<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EntityBase StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:EntityBase
 * @subpackage Structs
 */
class EntityBase extends AbstractStructBase
{
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - ref: ser:Id
     * @var string
     */
    public $Id;
    /**
     * The Ref
     * Meta information extracted from the WSDL
     * - ref: ser:Ref
     * @var string
     */
    public $Ref;
    /**
     * Constructor method for EntityBase
     * @uses EntityBase::setId()
     * @uses EntityBase::setRef()
     * @param string $id
     * @param string $ref
     */
    public function __construct($id = null, $ref = null)
    {
        $this
            ->setId($id)
            ->setRef($ref);
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\EntityBase
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get Ref value
     * @return string|null
     */
    public function getRef()
    {
        return $this->Ref;
    }
    /**
     * Set Ref value
     * @param string $ref
     * @return \StructType\EntityBase
     */
    public function setRef($ref = null)
    {
        // validation for constraint: string
        if (!is_null($ref) && !is_string($ref)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ref, true), gettype($ref)), __LINE__);
        }
        $this->Ref = $ref;
        return $this;
    }
}
