<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CancelShipments StructType
 * @subpackage Structs
 */
class CancelShipments extends AbstractStructBase
{
    /**
     * The shipments
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfCancelShipmentRow
     */
    public $shipments;
    /**
     * Constructor method for CancelShipments
     * @uses CancelShipments::setShipments()
     * @param \ArrayType\ArrayOfCancelShipmentRow $shipments
     */
    public function __construct(\ArrayType\ArrayOfCancelShipmentRow $shipments = null)
    {
        $this
            ->setShipments($shipments);
    }
    /**
     * Get shipments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfCancelShipmentRow|null
     */
    public function getShipments()
    {
        return isset($this->shipments) ? $this->shipments : null;
    }
    /**
     * Set shipments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfCancelShipmentRow $shipments
     * @return \StructType\CancelShipments
     */
    public function setShipments(\ArrayType\ArrayOfCancelShipmentRow $shipments = null)
    {
        if (is_null($shipments) || (is_array($shipments) && empty($shipments))) {
            unset($this->shipments);
        } else {
            $this->shipments = $shipments;
        }
        return $this;
    }
}
