<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CancelShipmentRow StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: q56:CancelShipmentRow
 * @subpackage Structs
 */
class CancelShipmentRow extends AbstractStructBase
{
    /**
     * The ClientID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ClientID;
    /**
     * The ColloCodeList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $ColloCodeList;
    /**
     * The Number
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Number;
    /**
     * The OrgUnitGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrgUnitGuid;
    /**
     * The OrgUnitID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $OrgUnitID;
    /**
     * Constructor method for CancelShipmentRow
     * @uses CancelShipmentRow::setClientID()
     * @uses CancelShipmentRow::setColloCodeList()
     * @uses CancelShipmentRow::setNumber()
     * @uses CancelShipmentRow::setOrgUnitGuid()
     * @uses CancelShipmentRow::setOrgUnitID()
     * @param int $clientID
     * @param \ArrayType\ArrayOfstring $colloCodeList
     * @param string $number
     * @param string $orgUnitGuid
     * @param int $orgUnitID
     */
    public function __construct($clientID = null, \ArrayType\ArrayOfstring $colloCodeList = null, $number = null, $orgUnitGuid = null, $orgUnitID = null)
    {
        $this
            ->setClientID($clientID)
            ->setColloCodeList($colloCodeList)
            ->setNumber($number)
            ->setOrgUnitGuid($orgUnitGuid)
            ->setOrgUnitID($orgUnitID);
    }
    /**
     * Get ClientID value
     * @return int|null
     */
    public function getClientID()
    {
        return $this->ClientID;
    }
    /**
     * Set ClientID value
     * @param int $clientID
     * @return \StructType\CancelShipmentRow
     */
    public function setClientID($clientID = null)
    {
        // validation for constraint: int
        if (!is_null($clientID) && !(is_int($clientID) || ctype_digit($clientID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($clientID, true), gettype($clientID)), __LINE__);
        }
        $this->ClientID = $clientID;
        return $this;
    }
    /**
     * Get ColloCodeList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getColloCodeList()
    {
        return isset($this->ColloCodeList) ? $this->ColloCodeList : null;
    }
    /**
     * Set ColloCodeList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfstring $colloCodeList
     * @return \StructType\CancelShipmentRow
     */
    public function setColloCodeList(\ArrayType\ArrayOfstring $colloCodeList = null)
    {
        if (is_null($colloCodeList) || (is_array($colloCodeList) && empty($colloCodeList))) {
            unset($this->ColloCodeList);
        } else {
            $this->ColloCodeList = $colloCodeList;
        }
        return $this;
    }
    /**
     * Get Number value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNumber()
    {
        return isset($this->Number) ? $this->Number : null;
    }
    /**
     * Set Number value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $number
     * @return \StructType\CancelShipmentRow
     */
    public function setNumber($number = null)
    {
        // validation for constraint: string
        if (!is_null($number) && !is_string($number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($number, true), gettype($number)), __LINE__);
        }
        if (is_null($number) || (is_array($number) && empty($number))) {
            unset($this->Number);
        } else {
            $this->Number = $number;
        }
        return $this;
    }
    /**
     * Get OrgUnitGuid value
     * @return string|null
     */
    public function getOrgUnitGuid()
    {
        return $this->OrgUnitGuid;
    }
    /**
     * Set OrgUnitGuid value
     * @param string $orgUnitGuid
     * @return \StructType\CancelShipmentRow
     */
    public function setOrgUnitGuid($orgUnitGuid = null)
    {
        // validation for constraint: string
        if (!is_null($orgUnitGuid) && !is_string($orgUnitGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orgUnitGuid, true), gettype($orgUnitGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($orgUnitGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $orgUnitGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($orgUnitGuid, true)), __LINE__);
        }
        $this->OrgUnitGuid = $orgUnitGuid;
        return $this;
    }
    /**
     * Get OrgUnitID value
     * @return int|null
     */
    public function getOrgUnitID()
    {
        return $this->OrgUnitID;
    }
    /**
     * Set OrgUnitID value
     * @param int $orgUnitID
     * @return \StructType\CancelShipmentRow
     */
    public function setOrgUnitID($orgUnitID = null)
    {
        // validation for constraint: int
        if (!is_null($orgUnitID) && !(is_int($orgUnitID) || ctype_digit($orgUnitID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($orgUnitID, true), gettype($orgUnitID)), __LINE__);
        }
        $this->OrgUnitID = $orgUnitID;
        return $this;
    }
}
