<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AdditionalInformationResult StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: q51:AdditionalInformationResult
 * @subpackage Structs
 */
class AdditionalInformationResult extends AbstractStructBase
{
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The ThirdPartyID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ThirdPartyID;
    /**
     * Constructor method for AdditionalInformationResult
     * @uses AdditionalInformationResult::setName()
     * @uses AdditionalInformationResult::setThirdPartyID()
     * @param string $name
     * @param string $thirdPartyID
     */
    public function __construct($name = null, $thirdPartyID = null)
    {
        $this
            ->setName($name)
            ->setThirdPartyID($thirdPartyID);
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \StructType\AdditionalInformationResult
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get ThirdPartyID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getThirdPartyID()
    {
        return isset($this->ThirdPartyID) ? $this->ThirdPartyID : null;
    }
    /**
     * Set ThirdPartyID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $thirdPartyID
     * @return \StructType\AdditionalInformationResult
     */
    public function setThirdPartyID($thirdPartyID = null)
    {
        // validation for constraint: string
        if (!is_null($thirdPartyID) && !is_string($thirdPartyID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($thirdPartyID, true), gettype($thirdPartyID)), __LINE__);
        }
        if (is_null($thirdPartyID) || (is_array($thirdPartyID) && empty($thirdPartyID))) {
            unset($this->ThirdPartyID);
        } else {
            $this->ThirdPartyID = $thirdPartyID;
        }
        return $this;
    }
}
