<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Perform ServiceType
 * @subpackage Services
 */
class Perform extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named PerformEndOfDay
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PerformEndOfDay $parameters
     * @return \StructType\PerformEndOfDayResponse|bool
     */
    public function PerformEndOfDay(\StructType\PerformEndOfDay $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PerformEndOfDay($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PerformEndOfDaySelect
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PerformEndOfDaySelect $parameters
     * @return \StructType\PerformEndOfDaySelectResponse|bool
     */
    public function PerformEndOfDaySelect(\StructType\PerformEndOfDaySelect $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PerformEndOfDaySelect($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\PerformEndOfDayResponse|\StructType\PerformEndOfDaySelectResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
