<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShipmentRow StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: q10:ShipmentRow
 * @subpackage Structs
 */
class ShipmentRow extends AbstractStructBase
{
    /**
     * The AlternativeReturnOrgUnitAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AddressRow
     */
    public $AlternativeReturnOrgUnitAddress;
    /**
     * The BusinessDocumentEntryList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $BusinessDocumentEntryList;
    /**
     * The ClientID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ClientID;
    /**
     * The ColloList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfColloRow
     */
    public $ColloList;
    /**
     * The CostCenterThirdPartyID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CostCenterThirdPartyID;
    /**
     * The CustomDataBit1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $CustomDataBit1;
    /**
     * The CustomDataBit2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $CustomDataBit2;
    /**
     * The CustomerProduct
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CustomerProduct;
    /**
     * The CustomsDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CustomsDescription;
    /**
     * The DeliveryInstruction
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DeliveryInstruction;
    /**
     * The DeliveryServiceThirdPartyID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DeliveryServiceThirdPartyID;
    /**
     * The FeatureList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfAdditionalInformationRow
     */
    public $FeatureList;
    /**
     * The MovementReferenceNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MovementReferenceNumber;
    /**
     * The Number
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Number;
    /**
     * The OURecipientAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AddressRow
     */
    public $OURecipientAddress;
    /**
     * The OUShipperAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AddressRow
     */
    public $OUShipperAddress;
    /**
     * The OUShipperReference1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OUShipperReference1;
    /**
     * The OUShipperReference2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OUShipperReference2;
    /**
     * The OrgUnitGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrgUnitGuid;
    /**
     * The OrgUnitID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $OrgUnitID;
    /**
     * The PrinterObject
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PrinterRow
     */
    public $PrinterObject;
    /**
     * The RefBarcodeType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RefBarcodeType;
    /**
     * The ReturnDays
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ReturnDays;
    /**
     * The ReturnModeID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ReturnModeID;
    /**
     * The ReturnOptionID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ReturnOptionID;
    /**
     * The ShipmentDocumentEntryList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfShipmentDocumentEntry
     */
    public $ShipmentDocumentEntryList;
    /**
     * The ShippingDateTimeFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ShippingDateTimeFrom;
    /**
     * The ShippingDateTimeTo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ShippingDateTimeTo;
    /**
     * Constructor method for ShipmentRow
     * @uses ShipmentRow::setAlternativeReturnOrgUnitAddress()
     * @uses ShipmentRow::setBusinessDocumentEntryList()
     * @uses ShipmentRow::setClientID()
     * @uses ShipmentRow::setColloList()
     * @uses ShipmentRow::setCostCenterThirdPartyID()
     * @uses ShipmentRow::setCustomDataBit1()
     * @uses ShipmentRow::setCustomDataBit2()
     * @uses ShipmentRow::setCustomerProduct()
     * @uses ShipmentRow::setCustomsDescription()
     * @uses ShipmentRow::setDeliveryInstruction()
     * @uses ShipmentRow::setDeliveryServiceThirdPartyID()
     * @uses ShipmentRow::setFeatureList()
     * @uses ShipmentRow::setMovementReferenceNumber()
     * @uses ShipmentRow::setNumber()
     * @uses ShipmentRow::setOURecipientAddress()
     * @uses ShipmentRow::setOUShipperAddress()
     * @uses ShipmentRow::setOUShipperReference1()
     * @uses ShipmentRow::setOUShipperReference2()
     * @uses ShipmentRow::setOrgUnitGuid()
     * @uses ShipmentRow::setOrgUnitID()
     * @uses ShipmentRow::setPrinterObject()
     * @uses ShipmentRow::setRefBarcodeType()
     * @uses ShipmentRow::setReturnDays()
     * @uses ShipmentRow::setReturnModeID()
     * @uses ShipmentRow::setReturnOptionID()
     * @uses ShipmentRow::setShipmentDocumentEntryList()
     * @uses ShipmentRow::setShippingDateTimeFrom()
     * @uses ShipmentRow::setShippingDateTimeTo()
     * @param \StructType\AddressRow $alternativeReturnOrgUnitAddress
     * @param \ArrayType\ArrayOfstring $businessDocumentEntryList
     * @param int $clientID
     * @param \ArrayType\ArrayOfColloRow $colloList
     * @param string $costCenterThirdPartyID
     * @param bool $customDataBit1
     * @param bool $customDataBit2
     * @param string $customerProduct
     * @param string $customsDescription
     * @param string $deliveryInstruction
     * @param string $deliveryServiceThirdPartyID
     * @param \ArrayType\ArrayOfAdditionalInformationRow $featureList
     * @param string $movementReferenceNumber
     * @param string $number
     * @param \StructType\AddressRow $oURecipientAddress
     * @param \StructType\AddressRow $oUShipperAddress
     * @param string $oUShipperReference1
     * @param string $oUShipperReference2
     * @param string $orgUnitGuid
     * @param int $orgUnitID
     * @param \StructType\PrinterRow $printerObject
     * @param string $refBarcodeType
     * @param int $returnDays
     * @param int $returnModeID
     * @param int $returnOptionID
     * @param \ArrayType\ArrayOfShipmentDocumentEntry $shipmentDocumentEntryList
     * @param string $shippingDateTimeFrom
     * @param string $shippingDateTimeTo
     */
    public function __construct(\StructType\AddressRow $alternativeReturnOrgUnitAddress = null, \ArrayType\ArrayOfstring $businessDocumentEntryList = null, $clientID = null, \ArrayType\ArrayOfColloRow $colloList = null, $costCenterThirdPartyID = null, $customDataBit1 = null, $customDataBit2 = null, $customerProduct = null, $customsDescription = null, $deliveryInstruction = null, $deliveryServiceThirdPartyID = null, \ArrayType\ArrayOfAdditionalInformationRow $featureList = null, $movementReferenceNumber = null, $number = null, \StructType\AddressRow $oURecipientAddress = null, \StructType\AddressRow $oUShipperAddress = null, $oUShipperReference1 = null, $oUShipperReference2 = null, $orgUnitGuid = null, $orgUnitID = null, \StructType\PrinterRow $printerObject = null, $refBarcodeType = null, $returnDays = null, $returnModeID = null, $returnOptionID = null, \ArrayType\ArrayOfShipmentDocumentEntry $shipmentDocumentEntryList = null, $shippingDateTimeFrom = null, $shippingDateTimeTo = null)
    {
        $this
            ->setAlternativeReturnOrgUnitAddress($alternativeReturnOrgUnitAddress)
            ->setBusinessDocumentEntryList($businessDocumentEntryList)
            ->setClientID($clientID)
            ->setColloList($colloList)
            ->setCostCenterThirdPartyID($costCenterThirdPartyID)
            ->setCustomDataBit1($customDataBit1)
            ->setCustomDataBit2($customDataBit2)
            ->setCustomerProduct($customerProduct)
            ->setCustomsDescription($customsDescription)
            ->setDeliveryInstruction($deliveryInstruction)
            ->setDeliveryServiceThirdPartyID($deliveryServiceThirdPartyID)
            ->setFeatureList($featureList)
            ->setMovementReferenceNumber($movementReferenceNumber)
            ->setNumber($number)
            ->setOURecipientAddress($oURecipientAddress)
            ->setOUShipperAddress($oUShipperAddress)
            ->setOUShipperReference1($oUShipperReference1)
            ->setOUShipperReference2($oUShipperReference2)
            ->setOrgUnitGuid($orgUnitGuid)
            ->setOrgUnitID($orgUnitID)
            ->setPrinterObject($printerObject)
            ->setRefBarcodeType($refBarcodeType)
            ->setReturnDays($returnDays)
            ->setReturnModeID($returnModeID)
            ->setReturnOptionID($returnOptionID)
            ->setShipmentDocumentEntryList($shipmentDocumentEntryList)
            ->setShippingDateTimeFrom($shippingDateTimeFrom)
            ->setShippingDateTimeTo($shippingDateTimeTo);
    }
    /**
     * Get AlternativeReturnOrgUnitAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AddressRow|null
     */
    public function getAlternativeReturnOrgUnitAddress()
    {
        return isset($this->AlternativeReturnOrgUnitAddress) ? $this->AlternativeReturnOrgUnitAddress : null;
    }
    /**
     * Set AlternativeReturnOrgUnitAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\AddressRow $alternativeReturnOrgUnitAddress
     * @return \StructType\ShipmentRow
     */
    public function setAlternativeReturnOrgUnitAddress(\StructType\AddressRow $alternativeReturnOrgUnitAddress = null)
    {
        if (is_null($alternativeReturnOrgUnitAddress) || (is_array($alternativeReturnOrgUnitAddress) && empty($alternativeReturnOrgUnitAddress))) {
            unset($this->AlternativeReturnOrgUnitAddress);
        } else {
            $this->AlternativeReturnOrgUnitAddress = $alternativeReturnOrgUnitAddress;
        }
        return $this;
    }
    /**
     * Get BusinessDocumentEntryList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getBusinessDocumentEntryList()
    {
        return isset($this->BusinessDocumentEntryList) ? $this->BusinessDocumentEntryList : null;
    }
    /**
     * Set BusinessDocumentEntryList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfstring $businessDocumentEntryList
     * @return \StructType\ShipmentRow
     */
    public function setBusinessDocumentEntryList(\ArrayType\ArrayOfstring $businessDocumentEntryList = null)
    {
        if (is_null($businessDocumentEntryList) || (is_array($businessDocumentEntryList) && empty($businessDocumentEntryList))) {
            unset($this->BusinessDocumentEntryList);
        } else {
            $this->BusinessDocumentEntryList = $businessDocumentEntryList;
        }
        return $this;
    }
    /**
     * Get ClientID value
     * @return int|null
     */
    public function getClientID()
    {
        return $this->ClientID;
    }
    /**
     * Set ClientID value
     * @param int $clientID
     * @return \StructType\ShipmentRow
     */
    public function setClientID($clientID = null)
    {
        // validation for constraint: int
        if (!is_null($clientID) && !(is_int($clientID) || ctype_digit($clientID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($clientID, true), gettype($clientID)), __LINE__);
        }
        $this->ClientID = $clientID;
        return $this;
    }
    /**
     * Get ColloList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfColloRow|null
     */
    public function getColloList()
    {
        return isset($this->ColloList) ? $this->ColloList : null;
    }
    /**
     * Set ColloList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfColloRow $colloList
     * @return \StructType\ShipmentRow
     */
    public function setColloList(\ArrayType\ArrayOfColloRow $colloList = null)
    {
        if (is_null($colloList) || (is_array($colloList) && empty($colloList))) {
            unset($this->ColloList);
        } else {
            $this->ColloList = $colloList;
        }
        return $this;
    }
    /**
     * Get CostCenterThirdPartyID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCostCenterThirdPartyID()
    {
        return isset($this->CostCenterThirdPartyID) ? $this->CostCenterThirdPartyID : null;
    }
    /**
     * Set CostCenterThirdPartyID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $costCenterThirdPartyID
     * @return \StructType\ShipmentRow
     */
    public function setCostCenterThirdPartyID($costCenterThirdPartyID = null)
    {
        // validation for constraint: string
        if (!is_null($costCenterThirdPartyID) && !is_string($costCenterThirdPartyID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($costCenterThirdPartyID, true), gettype($costCenterThirdPartyID)), __LINE__);
        }
        if (is_null($costCenterThirdPartyID) || (is_array($costCenterThirdPartyID) && empty($costCenterThirdPartyID))) {
            unset($this->CostCenterThirdPartyID);
        } else {
            $this->CostCenterThirdPartyID = $costCenterThirdPartyID;
        }
        return $this;
    }
    /**
     * Get CustomDataBit1 value
     * @return bool|null
     */
    public function getCustomDataBit1()
    {
        return $this->CustomDataBit1;
    }
    /**
     * Set CustomDataBit1 value
     * @param bool $customDataBit1
     * @return \StructType\ShipmentRow
     */
    public function setCustomDataBit1($customDataBit1 = null)
    {
        // validation for constraint: boolean
        if (!is_null($customDataBit1) && !is_bool($customDataBit1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($customDataBit1, true), gettype($customDataBit1)), __LINE__);
        }
        $this->CustomDataBit1 = $customDataBit1;
        return $this;
    }
    /**
     * Get CustomDataBit2 value
     * @return bool|null
     */
    public function getCustomDataBit2()
    {
        return $this->CustomDataBit2;
    }
    /**
     * Set CustomDataBit2 value
     * @param bool $customDataBit2
     * @return \StructType\ShipmentRow
     */
    public function setCustomDataBit2($customDataBit2 = null)
    {
        // validation for constraint: boolean
        if (!is_null($customDataBit2) && !is_bool($customDataBit2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($customDataBit2, true), gettype($customDataBit2)), __LINE__);
        }
        $this->CustomDataBit2 = $customDataBit2;
        return $this;
    }
    /**
     * Get CustomerProduct value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCustomerProduct()
    {
        return isset($this->CustomerProduct) ? $this->CustomerProduct : null;
    }
    /**
     * Set CustomerProduct value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $customerProduct
     * @return \StructType\ShipmentRow
     */
    public function setCustomerProduct($customerProduct = null)
    {
        // validation for constraint: string
        if (!is_null($customerProduct) && !is_string($customerProduct)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerProduct, true), gettype($customerProduct)), __LINE__);
        }
        if (is_null($customerProduct) || (is_array($customerProduct) && empty($customerProduct))) {
            unset($this->CustomerProduct);
        } else {
            $this->CustomerProduct = $customerProduct;
        }
        return $this;
    }
    /**
     * Get CustomsDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCustomsDescription()
    {
        return isset($this->CustomsDescription) ? $this->CustomsDescription : null;
    }
    /**
     * Set CustomsDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $customsDescription
     * @return \StructType\ShipmentRow
     */
    public function setCustomsDescription($customsDescription = null)
    {
        // validation for constraint: string
        if (!is_null($customsDescription) && !is_string($customsDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customsDescription, true), gettype($customsDescription)), __LINE__);
        }
        if (is_null($customsDescription) || (is_array($customsDescription) && empty($customsDescription))) {
            unset($this->CustomsDescription);
        } else {
            $this->CustomsDescription = $customsDescription;
        }
        return $this;
    }
    /**
     * Get DeliveryInstruction value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeliveryInstruction()
    {
        return isset($this->DeliveryInstruction) ? $this->DeliveryInstruction : null;
    }
    /**
     * Set DeliveryInstruction value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $deliveryInstruction
     * @return \StructType\ShipmentRow
     */
    public function setDeliveryInstruction($deliveryInstruction = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryInstruction) && !is_string($deliveryInstruction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryInstruction, true), gettype($deliveryInstruction)), __LINE__);
        }
        if (is_null($deliveryInstruction) || (is_array($deliveryInstruction) && empty($deliveryInstruction))) {
            unset($this->DeliveryInstruction);
        } else {
            $this->DeliveryInstruction = $deliveryInstruction;
        }
        return $this;
    }
    /**
     * Get DeliveryServiceThirdPartyID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeliveryServiceThirdPartyID()
    {
        return isset($this->DeliveryServiceThirdPartyID) ? $this->DeliveryServiceThirdPartyID : null;
    }
    /**
     * Set DeliveryServiceThirdPartyID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $deliveryServiceThirdPartyID
     * @return \StructType\ShipmentRow
     */
    public function setDeliveryServiceThirdPartyID($deliveryServiceThirdPartyID = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryServiceThirdPartyID) && !is_string($deliveryServiceThirdPartyID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryServiceThirdPartyID, true), gettype($deliveryServiceThirdPartyID)), __LINE__);
        }
        if (is_null($deliveryServiceThirdPartyID) || (is_array($deliveryServiceThirdPartyID) && empty($deliveryServiceThirdPartyID))) {
            unset($this->DeliveryServiceThirdPartyID);
        } else {
            $this->DeliveryServiceThirdPartyID = $deliveryServiceThirdPartyID;
        }
        return $this;
    }
    /**
     * Get FeatureList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfAdditionalInformationRow|null
     */
    public function getFeatureList()
    {
        return isset($this->FeatureList) ? $this->FeatureList : null;
    }
    /**
     * Set FeatureList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfAdditionalInformationRow $featureList
     * @return \StructType\ShipmentRow
     */
    public function setFeatureList(\ArrayType\ArrayOfAdditionalInformationRow $featureList = null)
    {
        if (is_null($featureList) || (is_array($featureList) && empty($featureList))) {
            unset($this->FeatureList);
        } else {
            $this->FeatureList = $featureList;
        }
        return $this;
    }
    /**
     * Get MovementReferenceNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMovementReferenceNumber()
    {
        return isset($this->MovementReferenceNumber) ? $this->MovementReferenceNumber : null;
    }
    /**
     * Set MovementReferenceNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $movementReferenceNumber
     * @return \StructType\ShipmentRow
     */
    public function setMovementReferenceNumber($movementReferenceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($movementReferenceNumber) && !is_string($movementReferenceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($movementReferenceNumber, true), gettype($movementReferenceNumber)), __LINE__);
        }
        if (is_null($movementReferenceNumber) || (is_array($movementReferenceNumber) && empty($movementReferenceNumber))) {
            unset($this->MovementReferenceNumber);
        } else {
            $this->MovementReferenceNumber = $movementReferenceNumber;
        }
        return $this;
    }
    /**
     * Get Number value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNumber()
    {
        return isset($this->Number) ? $this->Number : null;
    }
    /**
     * Set Number value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $number
     * @return \StructType\ShipmentRow
     */
    public function setNumber($number = null)
    {
        // validation for constraint: string
        if (!is_null($number) && !is_string($number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($number, true), gettype($number)), __LINE__);
        }
        if (is_null($number) || (is_array($number) && empty($number))) {
            unset($this->Number);
        } else {
            $this->Number = $number;
        }
        return $this;
    }
    /**
     * Get OURecipientAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AddressRow|null
     */
    public function getOURecipientAddress()
    {
        return isset($this->OURecipientAddress) ? $this->OURecipientAddress : null;
    }
    /**
     * Set OURecipientAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\AddressRow $oURecipientAddress
     * @return \StructType\ShipmentRow
     */
    public function setOURecipientAddress(\StructType\AddressRow $oURecipientAddress = null)
    {
        if (is_null($oURecipientAddress) || (is_array($oURecipientAddress) && empty($oURecipientAddress))) {
            unset($this->OURecipientAddress);
        } else {
            $this->OURecipientAddress = $oURecipientAddress;
        }
        return $this;
    }
    /**
     * Get OUShipperAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AddressRow|null
     */
    public function getOUShipperAddress()
    {
        return isset($this->OUShipperAddress) ? $this->OUShipperAddress : null;
    }
    /**
     * Set OUShipperAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\AddressRow $oUShipperAddress
     * @return \StructType\ShipmentRow
     */
    public function setOUShipperAddress(\StructType\AddressRow $oUShipperAddress = null)
    {
        if (is_null($oUShipperAddress) || (is_array($oUShipperAddress) && empty($oUShipperAddress))) {
            unset($this->OUShipperAddress);
        } else {
            $this->OUShipperAddress = $oUShipperAddress;
        }
        return $this;
    }
    /**
     * Get OUShipperReference1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOUShipperReference1()
    {
        return isset($this->OUShipperReference1) ? $this->OUShipperReference1 : null;
    }
    /**
     * Set OUShipperReference1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $oUShipperReference1
     * @return \StructType\ShipmentRow
     */
    public function setOUShipperReference1($oUShipperReference1 = null)
    {
        // validation for constraint: string
        if (!is_null($oUShipperReference1) && !is_string($oUShipperReference1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oUShipperReference1, true), gettype($oUShipperReference1)), __LINE__);
        }
        if (is_null($oUShipperReference1) || (is_array($oUShipperReference1) && empty($oUShipperReference1))) {
            unset($this->OUShipperReference1);
        } else {
            $this->OUShipperReference1 = $oUShipperReference1;
        }
        return $this;
    }
    /**
     * Get OUShipperReference2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOUShipperReference2()
    {
        return isset($this->OUShipperReference2) ? $this->OUShipperReference2 : null;
    }
    /**
     * Set OUShipperReference2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $oUShipperReference2
     * @return \StructType\ShipmentRow
     */
    public function setOUShipperReference2($oUShipperReference2 = null)
    {
        // validation for constraint: string
        if (!is_null($oUShipperReference2) && !is_string($oUShipperReference2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oUShipperReference2, true), gettype($oUShipperReference2)), __LINE__);
        }
        if (is_null($oUShipperReference2) || (is_array($oUShipperReference2) && empty($oUShipperReference2))) {
            unset($this->OUShipperReference2);
        } else {
            $this->OUShipperReference2 = $oUShipperReference2;
        }
        return $this;
    }
    /**
     * Get OrgUnitGuid value
     * @return string|null
     */
    public function getOrgUnitGuid()
    {
        return $this->OrgUnitGuid;
    }
    /**
     * Set OrgUnitGuid value
     * @param string $orgUnitGuid
     * @return \StructType\ShipmentRow
     */
    public function setOrgUnitGuid($orgUnitGuid = null)
    {
        // validation for constraint: string
        if (!is_null($orgUnitGuid) && !is_string($orgUnitGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orgUnitGuid, true), gettype($orgUnitGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($orgUnitGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $orgUnitGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($orgUnitGuid, true)), __LINE__);
        }
        $this->OrgUnitGuid = $orgUnitGuid;
        return $this;
    }
    /**
     * Get OrgUnitID value
     * @return int|null
     */
    public function getOrgUnitID()
    {
        return $this->OrgUnitID;
    }
    /**
     * Set OrgUnitID value
     * @param int $orgUnitID
     * @return \StructType\ShipmentRow
     */
    public function setOrgUnitID($orgUnitID = null)
    {
        // validation for constraint: int
        if (!is_null($orgUnitID) && !(is_int($orgUnitID) || ctype_digit($orgUnitID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($orgUnitID, true), gettype($orgUnitID)), __LINE__);
        }
        $this->OrgUnitID = $orgUnitID;
        return $this;
    }
    /**
     * Get PrinterObject value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PrinterRow|null
     */
    public function getPrinterObject()
    {
        return isset($this->PrinterObject) ? $this->PrinterObject : null;
    }
    /**
     * Set PrinterObject value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\PrinterRow $printerObject
     * @return \StructType\ShipmentRow
     */
    public function setPrinterObject(\StructType\PrinterRow $printerObject = null)
    {
        if (is_null($printerObject) || (is_array($printerObject) && empty($printerObject))) {
            unset($this->PrinterObject);
        } else {
            $this->PrinterObject = $printerObject;
        }
        return $this;
    }
    /**
     * Get RefBarcodeType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRefBarcodeType()
    {
        return isset($this->RefBarcodeType) ? $this->RefBarcodeType : null;
    }
    /**
     * Set RefBarcodeType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $refBarcodeType
     * @return \StructType\ShipmentRow
     */
    public function setRefBarcodeType($refBarcodeType = null)
    {
        // validation for constraint: string
        if (!is_null($refBarcodeType) && !is_string($refBarcodeType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($refBarcodeType, true), gettype($refBarcodeType)), __LINE__);
        }
        if (is_null($refBarcodeType) || (is_array($refBarcodeType) && empty($refBarcodeType))) {
            unset($this->RefBarcodeType);
        } else {
            $this->RefBarcodeType = $refBarcodeType;
        }
        return $this;
    }
    /**
     * Get ReturnDays value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getReturnDays()
    {
        return isset($this->ReturnDays) ? $this->ReturnDays : null;
    }
    /**
     * Set ReturnDays value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $returnDays
     * @return \StructType\ShipmentRow
     */
    public function setReturnDays($returnDays = null)
    {
        // validation for constraint: int
        if (!is_null($returnDays) && !(is_int($returnDays) || ctype_digit($returnDays))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($returnDays, true), gettype($returnDays)), __LINE__);
        }
        if (is_null($returnDays) || (is_array($returnDays) && empty($returnDays))) {
            unset($this->ReturnDays);
        } else {
            $this->ReturnDays = $returnDays;
        }
        return $this;
    }
    /**
     * Get ReturnModeID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getReturnModeID()
    {
        return isset($this->ReturnModeID) ? $this->ReturnModeID : null;
    }
    /**
     * Set ReturnModeID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $returnModeID
     * @return \StructType\ShipmentRow
     */
    public function setReturnModeID($returnModeID = null)
    {
        // validation for constraint: int
        if (!is_null($returnModeID) && !(is_int($returnModeID) || ctype_digit($returnModeID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($returnModeID, true), gettype($returnModeID)), __LINE__);
        }
        if (is_null($returnModeID) || (is_array($returnModeID) && empty($returnModeID))) {
            unset($this->ReturnModeID);
        } else {
            $this->ReturnModeID = $returnModeID;
        }
        return $this;
    }
    /**
     * Get ReturnOptionID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getReturnOptionID()
    {
        return isset($this->ReturnOptionID) ? $this->ReturnOptionID : null;
    }
    /**
     * Set ReturnOptionID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $returnOptionID
     * @return \StructType\ShipmentRow
     */
    public function setReturnOptionID($returnOptionID = null)
    {
        // validation for constraint: int
        if (!is_null($returnOptionID) && !(is_int($returnOptionID) || ctype_digit($returnOptionID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($returnOptionID, true), gettype($returnOptionID)), __LINE__);
        }
        if (is_null($returnOptionID) || (is_array($returnOptionID) && empty($returnOptionID))) {
            unset($this->ReturnOptionID);
        } else {
            $this->ReturnOptionID = $returnOptionID;
        }
        return $this;
    }
    /**
     * Get ShipmentDocumentEntryList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfShipmentDocumentEntry|null
     */
    public function getShipmentDocumentEntryList()
    {
        return isset($this->ShipmentDocumentEntryList) ? $this->ShipmentDocumentEntryList : null;
    }
    /**
     * Set ShipmentDocumentEntryList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfShipmentDocumentEntry $shipmentDocumentEntryList
     * @return \StructType\ShipmentRow
     */
    public function setShipmentDocumentEntryList(\ArrayType\ArrayOfShipmentDocumentEntry $shipmentDocumentEntryList = null)
    {
        if (is_null($shipmentDocumentEntryList) || (is_array($shipmentDocumentEntryList) && empty($shipmentDocumentEntryList))) {
            unset($this->ShipmentDocumentEntryList);
        } else {
            $this->ShipmentDocumentEntryList = $shipmentDocumentEntryList;
        }
        return $this;
    }
    /**
     * Get ShippingDateTimeFrom value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getShippingDateTimeFrom()
    {
        return isset($this->ShippingDateTimeFrom) ? $this->ShippingDateTimeFrom : null;
    }
    /**
     * Set ShippingDateTimeFrom value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $shippingDateTimeFrom
     * @return \StructType\ShipmentRow
     */
    public function setShippingDateTimeFrom($shippingDateTimeFrom = null)
    {
        // validation for constraint: string
        if (!is_null($shippingDateTimeFrom) && !is_string($shippingDateTimeFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shippingDateTimeFrom, true), gettype($shippingDateTimeFrom)), __LINE__);
        }
        if (is_null($shippingDateTimeFrom) || (is_array($shippingDateTimeFrom) && empty($shippingDateTimeFrom))) {
            unset($this->ShippingDateTimeFrom);
        } else {
            $this->ShippingDateTimeFrom = $shippingDateTimeFrom;
        }
        return $this;
    }
    /**
     * Get ShippingDateTimeTo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getShippingDateTimeTo()
    {
        return isset($this->ShippingDateTimeTo) ? $this->ShippingDateTimeTo : null;
    }
    /**
     * Set ShippingDateTimeTo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $shippingDateTimeTo
     * @return \StructType\ShipmentRow
     */
    public function setShippingDateTimeTo($shippingDateTimeTo = null)
    {
        // validation for constraint: string
        if (!is_null($shippingDateTimeTo) && !is_string($shippingDateTimeTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shippingDateTimeTo, true), gettype($shippingDateTimeTo)), __LINE__);
        }
        if (is_null($shippingDateTimeTo) || (is_array($shippingDateTimeTo) && empty($shippingDateTimeTo))) {
            unset($this->ShippingDateTimeTo);
        } else {
            $this->ShippingDateTimeTo = $shippingDateTimeTo;
        }
        return $this;
    }
}
