<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShipmentDocumentEntry StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ShipmentDocumentEntry
 * @subpackage Structs
 */
class ShipmentDocumentEntry extends EntityBase
{
    /**
     * The DocumentID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $DocumentID;
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ID;
    /**
     * The Number
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Number;
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Quantity;
    /**
     * The ShipmentID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ShipmentID;
    /**
     * The DocumentDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DocumentDate;
    /**
     * The Comment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Comment;
    /**
     * The HasDocumentChanged
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $HasDocumentChanged;
    /**
     * The MultimediaContent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MultimediaContent;
    /**
     * The MultimediaFileName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MultimediaFileName;
    /**
     * The Reference1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Reference1;
    /**
     * The Reference2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Reference2;
    /**
     * The Reference3
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Reference3;
    /**
     * The ThirdPartyType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ThirdPartyType;
    /**
     * Constructor method for ShipmentDocumentEntry
     * @uses ShipmentDocumentEntry::setDocumentID()
     * @uses ShipmentDocumentEntry::setID()
     * @uses ShipmentDocumentEntry::setNumber()
     * @uses ShipmentDocumentEntry::setQuantity()
     * @uses ShipmentDocumentEntry::setShipmentID()
     * @uses ShipmentDocumentEntry::setDocumentDate()
     * @uses ShipmentDocumentEntry::setComment()
     * @uses ShipmentDocumentEntry::setHasDocumentChanged()
     * @uses ShipmentDocumentEntry::setMultimediaContent()
     * @uses ShipmentDocumentEntry::setMultimediaFileName()
     * @uses ShipmentDocumentEntry::setReference1()
     * @uses ShipmentDocumentEntry::setReference2()
     * @uses ShipmentDocumentEntry::setReference3()
     * @uses ShipmentDocumentEntry::setThirdPartyType()
     * @param int $documentID
     * @param int $iD
     * @param string $number
     * @param int $quantity
     * @param int $shipmentID
     * @param string $documentDate
     * @param string $comment
     * @param bool $hasDocumentChanged
     * @param string $multimediaContent
     * @param string $multimediaFileName
     * @param string $reference1
     * @param string $reference2
     * @param string $reference3
     * @param string $thirdPartyType
     */
    public function __construct($documentID = null, $iD = null, $number = null, $quantity = null, $shipmentID = null, $documentDate = null, $comment = null, $hasDocumentChanged = null, $multimediaContent = null, $multimediaFileName = null, $reference1 = null, $reference2 = null, $reference3 = null, $thirdPartyType = null)
    {
        $this
            ->setDocumentID($documentID)
            ->setID($iD)
            ->setNumber($number)
            ->setQuantity($quantity)
            ->setShipmentID($shipmentID)
            ->setDocumentDate($documentDate)
            ->setComment($comment)
            ->setHasDocumentChanged($hasDocumentChanged)
            ->setMultimediaContent($multimediaContent)
            ->setMultimediaFileName($multimediaFileName)
            ->setReference1($reference1)
            ->setReference2($reference2)
            ->setReference3($reference3)
            ->setThirdPartyType($thirdPartyType);
    }
    /**
     * Get DocumentID value
     * @return int|null
     */
    public function getDocumentID()
    {
        return $this->DocumentID;
    }
    /**
     * Set DocumentID value
     * @param int $documentID
     * @return \StructType\ShipmentDocumentEntry
     */
    public function setDocumentID($documentID = null)
    {
        // validation for constraint: int
        if (!is_null($documentID) && !(is_int($documentID) || ctype_digit($documentID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($documentID, true), gettype($documentID)), __LINE__);
        }
        $this->DocumentID = $documentID;
        return $this;
    }
    /**
     * Get ID value
     * @return int|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \StructType\ShipmentDocumentEntry
     */
    public function setID($iD = null)
    {
        // validation for constraint: int
        if (!is_null($iD) && !(is_int($iD) || ctype_digit($iD))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Number value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNumber()
    {
        return isset($this->Number) ? $this->Number : null;
    }
    /**
     * Set Number value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $number
     * @return \StructType\ShipmentDocumentEntry
     */
    public function setNumber($number = null)
    {
        // validation for constraint: string
        if (!is_null($number) && !is_string($number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($number, true), gettype($number)), __LINE__);
        }
        if (is_null($number) || (is_array($number) && empty($number))) {
            unset($this->Number);
        } else {
            $this->Number = $number;
        }
        return $this;
    }
    /**
     * Get Quantity value
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param int $quantity
     * @return \StructType\ShipmentDocumentEntry
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !(is_int($quantity) || ctype_digit($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get ShipmentID value
     * @return int|null
     */
    public function getShipmentID()
    {
        return $this->ShipmentID;
    }
    /**
     * Set ShipmentID value
     * @param int $shipmentID
     * @return \StructType\ShipmentDocumentEntry
     */
    public function setShipmentID($shipmentID = null)
    {
        // validation for constraint: int
        if (!is_null($shipmentID) && !(is_int($shipmentID) || ctype_digit($shipmentID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($shipmentID, true), gettype($shipmentID)), __LINE__);
        }
        $this->ShipmentID = $shipmentID;
        return $this;
    }
    /**
     * Get DocumentDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDocumentDate()
    {
        return isset($this->DocumentDate) ? $this->DocumentDate : null;
    }
    /**
     * Set DocumentDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $documentDate
     * @return \StructType\ShipmentDocumentEntry
     */
    public function setDocumentDate($documentDate = null)
    {
        // validation for constraint: string
        if (!is_null($documentDate) && !is_string($documentDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentDate, true), gettype($documentDate)), __LINE__);
        }
        if (is_null($documentDate) || (is_array($documentDate) && empty($documentDate))) {
            unset($this->DocumentDate);
        } else {
            $this->DocumentDate = $documentDate;
        }
        return $this;
    }
    /**
     * Get Comment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getComment()
    {
        return isset($this->Comment) ? $this->Comment : null;
    }
    /**
     * Set Comment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $comment
     * @return \StructType\ShipmentDocumentEntry
     */
    public function setComment($comment = null)
    {
        // validation for constraint: string
        if (!is_null($comment) && !is_string($comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comment, true), gettype($comment)), __LINE__);
        }
        if (is_null($comment) || (is_array($comment) && empty($comment))) {
            unset($this->Comment);
        } else {
            $this->Comment = $comment;
        }
        return $this;
    }
    /**
     * Get HasDocumentChanged value
     * @return bool|null
     */
    public function getHasDocumentChanged()
    {
        return $this->HasDocumentChanged;
    }
    /**
     * Set HasDocumentChanged value
     * @param bool $hasDocumentChanged
     * @return \StructType\ShipmentDocumentEntry
     */
    public function setHasDocumentChanged($hasDocumentChanged = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasDocumentChanged) && !is_bool($hasDocumentChanged)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hasDocumentChanged, true), gettype($hasDocumentChanged)), __LINE__);
        }
        $this->HasDocumentChanged = $hasDocumentChanged;
        return $this;
    }
    /**
     * Get MultimediaContent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMultimediaContent()
    {
        return isset($this->MultimediaContent) ? $this->MultimediaContent : null;
    }
    /**
     * Set MultimediaContent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $multimediaContent
     * @return \StructType\ShipmentDocumentEntry
     */
    public function setMultimediaContent($multimediaContent = null)
    {
        // validation for constraint: string
        if (!is_null($multimediaContent) && !is_string($multimediaContent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($multimediaContent, true), gettype($multimediaContent)), __LINE__);
        }
        if (is_null($multimediaContent) || (is_array($multimediaContent) && empty($multimediaContent))) {
            unset($this->MultimediaContent);
        } else {
            $this->MultimediaContent = $multimediaContent;
        }
        return $this;
    }
    /**
     * Get MultimediaFileName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMultimediaFileName()
    {
        return isset($this->MultimediaFileName) ? $this->MultimediaFileName : null;
    }
    /**
     * Set MultimediaFileName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $multimediaFileName
     * @return \StructType\ShipmentDocumentEntry
     */
    public function setMultimediaFileName($multimediaFileName = null)
    {
        // validation for constraint: string
        if (!is_null($multimediaFileName) && !is_string($multimediaFileName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($multimediaFileName, true), gettype($multimediaFileName)), __LINE__);
        }
        if (is_null($multimediaFileName) || (is_array($multimediaFileName) && empty($multimediaFileName))) {
            unset($this->MultimediaFileName);
        } else {
            $this->MultimediaFileName = $multimediaFileName;
        }
        return $this;
    }
    /**
     * Get Reference1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReference1()
    {
        return isset($this->Reference1) ? $this->Reference1 : null;
    }
    /**
     * Set Reference1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reference1
     * @return \StructType\ShipmentDocumentEntry
     */
    public function setReference1($reference1 = null)
    {
        // validation for constraint: string
        if (!is_null($reference1) && !is_string($reference1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reference1, true), gettype($reference1)), __LINE__);
        }
        if (is_null($reference1) || (is_array($reference1) && empty($reference1))) {
            unset($this->Reference1);
        } else {
            $this->Reference1 = $reference1;
        }
        return $this;
    }
    /**
     * Get Reference2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReference2()
    {
        return isset($this->Reference2) ? $this->Reference2 : null;
    }
    /**
     * Set Reference2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reference2
     * @return \StructType\ShipmentDocumentEntry
     */
    public function setReference2($reference2 = null)
    {
        // validation for constraint: string
        if (!is_null($reference2) && !is_string($reference2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reference2, true), gettype($reference2)), __LINE__);
        }
        if (is_null($reference2) || (is_array($reference2) && empty($reference2))) {
            unset($this->Reference2);
        } else {
            $this->Reference2 = $reference2;
        }
        return $this;
    }
    /**
     * Get Reference3 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReference3()
    {
        return isset($this->Reference3) ? $this->Reference3 : null;
    }
    /**
     * Set Reference3 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reference3
     * @return \StructType\ShipmentDocumentEntry
     */
    public function setReference3($reference3 = null)
    {
        // validation for constraint: string
        if (!is_null($reference3) && !is_string($reference3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reference3, true), gettype($reference3)), __LINE__);
        }
        if (is_null($reference3) || (is_array($reference3) && empty($reference3))) {
            unset($this->Reference3);
        } else {
            $this->Reference3 = $reference3;
        }
        return $this;
    }
    /**
     * Get ThirdPartyType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getThirdPartyType()
    {
        return isset($this->ThirdPartyType) ? $this->ThirdPartyType : null;
    }
    /**
     * Set ThirdPartyType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $thirdPartyType
     * @return \StructType\ShipmentDocumentEntry
     */
    public function setThirdPartyType($thirdPartyType = null)
    {
        // validation for constraint: string
        if (!is_null($thirdPartyType) && !is_string($thirdPartyType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($thirdPartyType, true), gettype($thirdPartyType)), __LINE__);
        }
        if (is_null($thirdPartyType) || (is_array($thirdPartyType) && empty($thirdPartyType))) {
            unset($this->ThirdPartyType);
        } else {
            $this->ThirdPartyType = $thirdPartyType;
        }
        return $this;
    }
}
