<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PrinterRow StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: q26:PrinterRow
 * @subpackage Structs
 */
class PrinterRow extends AbstractStructBase
{
    /**
     * The Encoding
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Encoding;
    /**
     * The LabelFormatID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LabelFormatID;
    /**
     * The LanguageID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LanguageID;
    /**
     * The PaperLayoutID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaperLayoutID;
    /**
     * Constructor method for PrinterRow
     * @uses PrinterRow::setEncoding()
     * @uses PrinterRow::setLabelFormatID()
     * @uses PrinterRow::setLanguageID()
     * @uses PrinterRow::setPaperLayoutID()
     * @param string $encoding
     * @param string $labelFormatID
     * @param string $languageID
     * @param string $paperLayoutID
     */
    public function __construct($encoding = null, $labelFormatID = null, $languageID = null, $paperLayoutID = null)
    {
        $this
            ->setEncoding($encoding)
            ->setLabelFormatID($labelFormatID)
            ->setLanguageID($languageID)
            ->setPaperLayoutID($paperLayoutID);
    }
    /**
     * Get Encoding value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEncoding()
    {
        return isset($this->Encoding) ? $this->Encoding : null;
    }
    /**
     * Set Encoding value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $encoding
     * @return \StructType\PrinterRow
     */
    public function setEncoding($encoding = null)
    {
        // validation for constraint: string
        if (!is_null($encoding) && !is_string($encoding)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($encoding, true), gettype($encoding)), __LINE__);
        }
        if (is_null($encoding) || (is_array($encoding) && empty($encoding))) {
            unset($this->Encoding);
        } else {
            $this->Encoding = $encoding;
        }
        return $this;
    }
    /**
     * Get LabelFormatID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLabelFormatID()
    {
        return isset($this->LabelFormatID) ? $this->LabelFormatID : null;
    }
    /**
     * Set LabelFormatID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $labelFormatID
     * @return \StructType\PrinterRow
     */
    public function setLabelFormatID($labelFormatID = null)
    {
        // validation for constraint: string
        if (!is_null($labelFormatID) && !is_string($labelFormatID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($labelFormatID, true), gettype($labelFormatID)), __LINE__);
        }
        if (is_null($labelFormatID) || (is_array($labelFormatID) && empty($labelFormatID))) {
            unset($this->LabelFormatID);
        } else {
            $this->LabelFormatID = $labelFormatID;
        }
        return $this;
    }
    /**
     * Get LanguageID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLanguageID()
    {
        return isset($this->LanguageID) ? $this->LanguageID : null;
    }
    /**
     * Set LanguageID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $languageID
     * @return \StructType\PrinterRow
     */
    public function setLanguageID($languageID = null)
    {
        // validation for constraint: string
        if (!is_null($languageID) && !is_string($languageID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($languageID, true), gettype($languageID)), __LINE__);
        }
        if (is_null($languageID) || (is_array($languageID) && empty($languageID))) {
            unset($this->LanguageID);
        } else {
            $this->LanguageID = $languageID;
        }
        return $this;
    }
    /**
     * Get PaperLayoutID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaperLayoutID()
    {
        return isset($this->PaperLayoutID) ? $this->PaperLayoutID : null;
    }
    /**
     * Set PaperLayoutID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paperLayoutID
     * @return \StructType\PrinterRow
     */
    public function setPaperLayoutID($paperLayoutID = null)
    {
        // validation for constraint: string
        if (!is_null($paperLayoutID) && !is_string($paperLayoutID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paperLayoutID, true), gettype($paperLayoutID)), __LINE__);
        }
        if (is_null($paperLayoutID) || (is_array($paperLayoutID) && empty($paperLayoutID))) {
            unset($this->PaperLayoutID);
        } else {
            $this->PaperLayoutID = $paperLayoutID;
        }
        return $this;
    }
}
