<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ColloRow StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: q16:ColloRow
 * @subpackage Structs
 */
class ColloRow extends AbstractStructBase
{
    /**
     * The ColloArticleList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfColloArticleRow
     */
    public $ColloArticleList;
    /**
     * The ColloCodeList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfColloCodeRow
     */
    public $ColloCodeList;
    /**
     * The Height
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Height;
    /**
     * The Length
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Length;
    /**
     * The Weight
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $Weight;
    /**
     * The Width
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Width;
    /**
     * Constructor method for ColloRow
     * @uses ColloRow::setColloArticleList()
     * @uses ColloRow::setColloCodeList()
     * @uses ColloRow::setHeight()
     * @uses ColloRow::setLength()
     * @uses ColloRow::setWeight()
     * @uses ColloRow::setWidth()
     * @param \ArrayType\ArrayOfColloArticleRow $colloArticleList
     * @param \ArrayType\ArrayOfColloCodeRow $colloCodeList
     * @param int $height
     * @param int $length
     * @param float $weight
     * @param int $width
     */
    public function __construct(\ArrayType\ArrayOfColloArticleRow $colloArticleList = null, \ArrayType\ArrayOfColloCodeRow $colloCodeList = null, $height = null, $length = null, $weight = null, $width = null)
    {
        $this
            ->setColloArticleList($colloArticleList)
            ->setColloCodeList($colloCodeList)
            ->setHeight($height)
            ->setLength($length)
            ->setWeight($weight)
            ->setWidth($width);
    }
    /**
     * Get ColloArticleList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfColloArticleRow|null
     */
    public function getColloArticleList()
    {
        return isset($this->ColloArticleList) ? $this->ColloArticleList : null;
    }
    /**
     * Set ColloArticleList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfColloArticleRow $colloArticleList
     * @return \StructType\ColloRow
     */
    public function setColloArticleList(\ArrayType\ArrayOfColloArticleRow $colloArticleList = null)
    {
        if (is_null($colloArticleList) || (is_array($colloArticleList) && empty($colloArticleList))) {
            unset($this->ColloArticleList);
        } else {
            $this->ColloArticleList = $colloArticleList;
        }
        return $this;
    }
    /**
     * Get ColloCodeList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfColloCodeRow|null
     */
    public function getColloCodeList()
    {
        return isset($this->ColloCodeList) ? $this->ColloCodeList : null;
    }
    /**
     * Set ColloCodeList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfColloCodeRow $colloCodeList
     * @return \StructType\ColloRow
     */
    public function setColloCodeList(\ArrayType\ArrayOfColloCodeRow $colloCodeList = null)
    {
        if (is_null($colloCodeList) || (is_array($colloCodeList) && empty($colloCodeList))) {
            unset($this->ColloCodeList);
        } else {
            $this->ColloCodeList = $colloCodeList;
        }
        return $this;
    }
    /**
     * Get Height value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getHeight()
    {
        return isset($this->Height) ? $this->Height : null;
    }
    /**
     * Set Height value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $height
     * @return \StructType\ColloRow
     */
    public function setHeight($height = null)
    {
        // validation for constraint: int
        if (!is_null($height) && !(is_int($height) || ctype_digit($height))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($height, true), gettype($height)), __LINE__);
        }
        if (is_null($height) || (is_array($height) && empty($height))) {
            unset($this->Height);
        } else {
            $this->Height = $height;
        }
        return $this;
    }
    /**
     * Get Length value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getLength()
    {
        return isset($this->Length) ? $this->Length : null;
    }
    /**
     * Set Length value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $length
     * @return \StructType\ColloRow
     */
    public function setLength($length = null)
    {
        // validation for constraint: int
        if (!is_null($length) && !(is_int($length) || ctype_digit($length))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($length, true), gettype($length)), __LINE__);
        }
        if (is_null($length) || (is_array($length) && empty($length))) {
            unset($this->Length);
        } else {
            $this->Length = $length;
        }
        return $this;
    }
    /**
     * Get Weight value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getWeight()
    {
        return isset($this->Weight) ? $this->Weight : null;
    }
    /**
     * Set Weight value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $weight
     * @return \StructType\ColloRow
     */
    public function setWeight($weight = null)
    {
        // validation for constraint: float
        if (!is_null($weight) && !(is_float($weight) || is_numeric($weight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($weight, true), gettype($weight)), __LINE__);
        }
        if (is_null($weight) || (is_array($weight) && empty($weight))) {
            unset($this->Weight);
        } else {
            $this->Weight = $weight;
        }
        return $this;
    }
    /**
     * Get Width value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getWidth()
    {
        return isset($this->Width) ? $this->Width : null;
    }
    /**
     * Set Width value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $width
     * @return \StructType\ColloRow
     */
    public function setWidth($width = null)
    {
        // validation for constraint: int
        if (!is_null($width) && !(is_int($width) || ctype_digit($width))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($width, true), gettype($width)), __LINE__);
        }
        if (is_null($width) || (is_array($width) && empty($width))) {
            unset($this->Width);
        } else {
            $this->Width = $width;
        }
        return $this;
    }
}
