<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ColloCodeRow StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: q22:ColloCodeRow
 * @subpackage Structs
 */
class ColloCodeRow extends AbstractStructBase
{
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Code;
    /**
     * The NumberTypeID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $NumberTypeID;
    /**
     * The OUCarrierThirdPartyID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OUCarrierThirdPartyID;
    /**
     * Constructor method for ColloCodeRow
     * @uses ColloCodeRow::setCode()
     * @uses ColloCodeRow::setNumberTypeID()
     * @uses ColloCodeRow::setOUCarrierThirdPartyID()
     * @param string $code
     * @param int $numberTypeID
     * @param string $oUCarrierThirdPartyID
     */
    public function __construct($code = null, $numberTypeID = null, $oUCarrierThirdPartyID = null)
    {
        $this
            ->setCode($code)
            ->setNumberTypeID($numberTypeID)
            ->setOUCarrierThirdPartyID($oUCarrierThirdPartyID);
    }
    /**
     * Get Code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCode()
    {
        return isset($this->Code) ? $this->Code : null;
    }
    /**
     * Set Code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $code
     * @return \StructType\ColloCodeRow
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        if (is_null($code) || (is_array($code) && empty($code))) {
            unset($this->Code);
        } else {
            $this->Code = $code;
        }
        return $this;
    }
    /**
     * Get NumberTypeID value
     * @return int|null
     */
    public function getNumberTypeID()
    {
        return $this->NumberTypeID;
    }
    /**
     * Set NumberTypeID value
     * @param int $numberTypeID
     * @return \StructType\ColloCodeRow
     */
    public function setNumberTypeID($numberTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($numberTypeID) && !(is_int($numberTypeID) || ctype_digit($numberTypeID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberTypeID, true), gettype($numberTypeID)), __LINE__);
        }
        $this->NumberTypeID = $numberTypeID;
        return $this;
    }
    /**
     * Get OUCarrierThirdPartyID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOUCarrierThirdPartyID()
    {
        return isset($this->OUCarrierThirdPartyID) ? $this->OUCarrierThirdPartyID : null;
    }
    /**
     * Set OUCarrierThirdPartyID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $oUCarrierThirdPartyID
     * @return \StructType\ColloCodeRow
     */
    public function setOUCarrierThirdPartyID($oUCarrierThirdPartyID = null)
    {
        // validation for constraint: string
        if (!is_null($oUCarrierThirdPartyID) && !is_string($oUCarrierThirdPartyID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oUCarrierThirdPartyID, true), gettype($oUCarrierThirdPartyID)), __LINE__);
        }
        if (is_null($oUCarrierThirdPartyID) || (is_array($oUCarrierThirdPartyID) && empty($oUCarrierThirdPartyID))) {
            unset($this->OUCarrierThirdPartyID);
        } else {
            $this->OUCarrierThirdPartyID = $oUCarrierThirdPartyID;
        }
        return $this;
    }
}
