<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://plc.post.at/Post.Webservice/ShippingService.svc?singleWsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://plc.post.at/Post.Webservice/ShippingService.svc?singleWsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Import ServiceType
 */
$import = new \ServiceType\Import($options);
/**
 * Sample call for ImportShipment operation/method
 */
if ($import->ImportShipment(new \StructType\ImportShipment()) !== false) {
    print_r($import->getResult());
} else {
    print_r($import->getLastError());
}
/**
 * Sample call for ImportShipmentAndGenerateBarcode operation/method
 */
if ($import->ImportShipmentAndGenerateBarcode(new \StructType\ImportShipmentAndGenerateBarcode()) !== false) {
    print_r($import->getResult());
} else {
    print_r($import->getLastError());
}
/**
 * Sample call for ImportShipmentReturnImage operation/method
 */
if ($import->ImportShipmentReturnImage(new \StructType\ImportShipmentReturnImage()) !== false) {
    print_r($import->getResult());
} else {
    print_r($import->getLastError());
}
/**
 * Sample call for ImportShipmentForce operation/method
 */
if ($import->ImportShipmentForce(new \StructType\ImportShipmentForce()) !== false) {
    print_r($import->getResult());
} else {
    print_r($import->getLastError());
}
/**
 * Sample call for ImportAddress operation/method
 */
if ($import->ImportAddress(new \StructType\ImportAddress()) !== false) {
    print_r($import->getResult());
} else {
    print_r($import->getLastError());
}
/**
 * Samples for Perform ServiceType
 */
$perform = new \ServiceType\Perform($options);
/**
 * Sample call for PerformEndOfDay operation/method
 */
if ($perform->PerformEndOfDay(new \StructType\PerformEndOfDay()) !== false) {
    print_r($perform->getResult());
} else {
    print_r($perform->getLastError());
}
/**
 * Sample call for PerformEndOfDaySelect operation/method
 */
if ($perform->PerformEndOfDaySelect(new \StructType\PerformEndOfDaySelect()) !== false) {
    print_r($perform->getResult());
} else {
    print_r($perform->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
/**
 * Sample call for GetAllowedServicesForCountry operation/method
 */
if ($get->GetAllowedServicesForCountry(new \StructType\GetAllowedServicesForCountry()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Cancel ServiceType
 */
$cancel = new \ServiceType\Cancel($options);
/**
 * Sample call for CancelShipments operation/method
 */
if ($cancel->CancelShipments(new \StructType\CancelShipments()) !== false) {
    print_r($cancel->getResult());
} else {
    print_r($cancel->getLastError());
}
