<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PerformEndOfDaySelect StructType
 * @subpackage Structs
 */
class PerformEndOfDaySelect extends AbstractStructBase
{
    /**
     * The clientID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $clientID;
    /**
     * The orgUnitID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $orgUnitID;
    /**
     * The orgUnitGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $orgUnitGuid;
    /**
     * The colloCodeList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $colloCodeList;
    /**
     * Constructor method for PerformEndOfDaySelect
     * @uses PerformEndOfDaySelect::setClientID()
     * @uses PerformEndOfDaySelect::setOrgUnitID()
     * @uses PerformEndOfDaySelect::setOrgUnitGuid()
     * @uses PerformEndOfDaySelect::setColloCodeList()
     * @param int $clientID
     * @param int $orgUnitID
     * @param string $orgUnitGuid
     * @param \ArrayType\ArrayOfstring $colloCodeList
     */
    public function __construct($clientID = null, $orgUnitID = null, $orgUnitGuid = null, \ArrayType\ArrayOfstring $colloCodeList = null)
    {
        $this
            ->setClientID($clientID)
            ->setOrgUnitID($orgUnitID)
            ->setOrgUnitGuid($orgUnitGuid)
            ->setColloCodeList($colloCodeList);
    }
    /**
     * Get clientID value
     * @return int|null
     */
    public function getClientID()
    {
        return $this->clientID;
    }
    /**
     * Set clientID value
     * @param int $clientID
     * @return \StructType\PerformEndOfDaySelect
     */
    public function setClientID($clientID = null)
    {
        // validation for constraint: int
        if (!is_null($clientID) && !(is_int($clientID) || ctype_digit($clientID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($clientID, true), gettype($clientID)), __LINE__);
        }
        $this->clientID = $clientID;
        return $this;
    }
    /**
     * Get orgUnitID value
     * @return int|null
     */
    public function getOrgUnitID()
    {
        return $this->orgUnitID;
    }
    /**
     * Set orgUnitID value
     * @param int $orgUnitID
     * @return \StructType\PerformEndOfDaySelect
     */
    public function setOrgUnitID($orgUnitID = null)
    {
        // validation for constraint: int
        if (!is_null($orgUnitID) && !(is_int($orgUnitID) || ctype_digit($orgUnitID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($orgUnitID, true), gettype($orgUnitID)), __LINE__);
        }
        $this->orgUnitID = $orgUnitID;
        return $this;
    }
    /**
     * Get orgUnitGuid value
     * @return string|null
     */
    public function getOrgUnitGuid()
    {
        return $this->orgUnitGuid;
    }
    /**
     * Set orgUnitGuid value
     * @param string $orgUnitGuid
     * @return \StructType\PerformEndOfDaySelect
     */
    public function setOrgUnitGuid($orgUnitGuid = null)
    {
        // validation for constraint: string
        if (!is_null($orgUnitGuid) && !is_string($orgUnitGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orgUnitGuid, true), gettype($orgUnitGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($orgUnitGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $orgUnitGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($orgUnitGuid, true)), __LINE__);
        }
        $this->orgUnitGuid = $orgUnitGuid;
        return $this;
    }
    /**
     * Get colloCodeList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getColloCodeList()
    {
        return isset($this->colloCodeList) ? $this->colloCodeList : null;
    }
    /**
     * Set colloCodeList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfstring $colloCodeList
     * @return \StructType\PerformEndOfDaySelect
     */
    public function setColloCodeList(\ArrayType\ArrayOfstring $colloCodeList = null)
    {
        if (is_null($colloCodeList) || (is_array($colloCodeList) && empty($colloCodeList))) {
            unset($this->colloCodeList);
        } else {
            $this->colloCodeList = $colloCodeList;
        }
        return $this;
    }
}
