<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CarrierServiceRow StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: q48:CarrierServiceRow
 * @subpackage Structs
 */
class CarrierServiceRow extends AbstractStructBase
{
    /**
     * The Contract
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Contract;
    /**
     * The FeatureList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfAdditionalInformationResult
     */
    public $FeatureList;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The OrderID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $OrderID;
    /**
     * The ThirdPartyID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ThirdPartyID;
    /**
     * Constructor method for CarrierServiceRow
     * @uses CarrierServiceRow::setContract()
     * @uses CarrierServiceRow::setFeatureList()
     * @uses CarrierServiceRow::setName()
     * @uses CarrierServiceRow::setOrderID()
     * @uses CarrierServiceRow::setThirdPartyID()
     * @param bool $contract
     * @param \ArrayType\ArrayOfAdditionalInformationResult $featureList
     * @param string $name
     * @param int $orderID
     * @param string $thirdPartyID
     */
    public function __construct($contract = null, \ArrayType\ArrayOfAdditionalInformationResult $featureList = null, $name = null, $orderID = null, $thirdPartyID = null)
    {
        $this
            ->setContract($contract)
            ->setFeatureList($featureList)
            ->setName($name)
            ->setOrderID($orderID)
            ->setThirdPartyID($thirdPartyID);
    }
    /**
     * Get Contract value
     * @return bool|null
     */
    public function getContract()
    {
        return $this->Contract;
    }
    /**
     * Set Contract value
     * @param bool $contract
     * @return \StructType\CarrierServiceRow
     */
    public function setContract($contract = null)
    {
        // validation for constraint: boolean
        if (!is_null($contract) && !is_bool($contract)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($contract, true), gettype($contract)), __LINE__);
        }
        $this->Contract = $contract;
        return $this;
    }
    /**
     * Get FeatureList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfAdditionalInformationResult|null
     */
    public function getFeatureList()
    {
        return isset($this->FeatureList) ? $this->FeatureList : null;
    }
    /**
     * Set FeatureList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfAdditionalInformationResult $featureList
     * @return \StructType\CarrierServiceRow
     */
    public function setFeatureList(\ArrayType\ArrayOfAdditionalInformationResult $featureList = null)
    {
        if (is_null($featureList) || (is_array($featureList) && empty($featureList))) {
            unset($this->FeatureList);
        } else {
            $this->FeatureList = $featureList;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \StructType\CarrierServiceRow
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get OrderID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getOrderID()
    {
        return isset($this->OrderID) ? $this->OrderID : null;
    }
    /**
     * Set OrderID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $orderID
     * @return \StructType\CarrierServiceRow
     */
    public function setOrderID($orderID = null)
    {
        // validation for constraint: int
        if (!is_null($orderID) && !(is_int($orderID) || ctype_digit($orderID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($orderID, true), gettype($orderID)), __LINE__);
        }
        if (is_null($orderID) || (is_array($orderID) && empty($orderID))) {
            unset($this->OrderID);
        } else {
            $this->OrderID = $orderID;
        }
        return $this;
    }
    /**
     * Get ThirdPartyID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getThirdPartyID()
    {
        return isset($this->ThirdPartyID) ? $this->ThirdPartyID : null;
    }
    /**
     * Set ThirdPartyID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $thirdPartyID
     * @return \StructType\CarrierServiceRow
     */
    public function setThirdPartyID($thirdPartyID = null)
    {
        // validation for constraint: string
        if (!is_null($thirdPartyID) && !is_string($thirdPartyID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($thirdPartyID, true), gettype($thirdPartyID)), __LINE__);
        }
        if (is_null($thirdPartyID) || (is_array($thirdPartyID) && empty($thirdPartyID))) {
            unset($this->ThirdPartyID);
        } else {
            $this->ThirdPartyID = $thirdPartyID;
        }
        return $this;
    }
}
