<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Import ServiceType
 * @subpackage Services
 */
class Import extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ImportShipment
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ImportShipment $parameters
     * @return \StructType\ImportShipmentResponse|bool
     */
    public function ImportShipment(\StructType\ImportShipment $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ImportShipment($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ImportShipmentAndGenerateBarcode
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ImportShipmentAndGenerateBarcode $parameters
     * @return \StructType\ImportShipmentAndGenerateBarcodeResponse|bool
     */
    public function ImportShipmentAndGenerateBarcode(\StructType\ImportShipmentAndGenerateBarcode $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ImportShipmentAndGenerateBarcode($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ImportShipmentReturnImage
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ImportShipmentReturnImage $parameters
     * @return \StructType\ImportShipmentReturnImageResponse|bool
     */
    public function ImportShipmentReturnImage(\StructType\ImportShipmentReturnImage $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ImportShipmentReturnImage($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ImportShipmentForce
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ImportShipmentForce $parameters
     * @return \StructType\ImportShipmentForceResponse|bool
     */
    public function ImportShipmentForce(\StructType\ImportShipmentForce $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ImportShipmentForce($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ImportAddress
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ImportAddress $parameters
     * @return \StructType\ImportAddressResponse|bool
     */
    public function ImportAddress(\StructType\ImportAddress $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ImportAddress($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ImportAddressResponse|\StructType\ImportShipmentAndGenerateBarcodeResponse|\StructType\ImportShipmentForceResponse|\StructType\ImportShipmentResponse|\StructType\ImportShipmentReturnImageResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
