<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfAdditionalInformationResult ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: q50:ArrayOfAdditionalInformationResult
 * @subpackage Arrays
 */
class ArrayOfAdditionalInformationResult extends AbstractStructArrayBase
{
    /**
     * The AdditionalInformationResult
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AdditionalInformationResult[]
     */
    public $AdditionalInformationResult;
    /**
     * Constructor method for ArrayOfAdditionalInformationResult
     * @uses ArrayOfAdditionalInformationResult::setAdditionalInformationResult()
     * @param \StructType\AdditionalInformationResult[] $additionalInformationResult
     */
    public function __construct(array $additionalInformationResult = array())
    {
        $this
            ->setAdditionalInformationResult($additionalInformationResult);
    }
    /**
     * Get AdditionalInformationResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AdditionalInformationResult[]|null
     */
    public function getAdditionalInformationResult()
    {
        return isset($this->AdditionalInformationResult) ? $this->AdditionalInformationResult : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAdditionalInformationResult method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAdditionalInformationResult method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAdditionalInformationResultForArrayConstraintsFromSetAdditionalInformationResult(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfAdditionalInformationResultAdditionalInformationResultItem) {
            // validation for constraint: itemType
            if (!$arrayOfAdditionalInformationResultAdditionalInformationResultItem instanceof \StructType\AdditionalInformationResult) {
                $invalidValues[] = is_object($arrayOfAdditionalInformationResultAdditionalInformationResultItem) ? get_class($arrayOfAdditionalInformationResultAdditionalInformationResultItem) : sprintf('%s(%s)', gettype($arrayOfAdditionalInformationResultAdditionalInformationResultItem), var_export($arrayOfAdditionalInformationResultAdditionalInformationResultItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AdditionalInformationResult property can only contain items of type \StructType\AdditionalInformationResult, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AdditionalInformationResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\AdditionalInformationResult[] $additionalInformationResult
     * @return \ArrayType\ArrayOfAdditionalInformationResult
     */
    public function setAdditionalInformationResult(array $additionalInformationResult = array())
    {
        // validation for constraint: array
        if ('' !== ($additionalInformationResultArrayErrorMessage = self::validateAdditionalInformationResultForArrayConstraintsFromSetAdditionalInformationResult($additionalInformationResult))) {
            throw new \InvalidArgumentException($additionalInformationResultArrayErrorMessage, __LINE__);
        }
        if (is_null($additionalInformationResult) || (is_array($additionalInformationResult) && empty($additionalInformationResult))) {
            unset($this->AdditionalInformationResult);
        } else {
            $this->AdditionalInformationResult = $additionalInformationResult;
        }
        return $this;
    }
    /**
     * Add item to AdditionalInformationResult value
     * @throws \InvalidArgumentException
     * @param \StructType\AdditionalInformationResult $item
     * @return \ArrayType\ArrayOfAdditionalInformationResult
     */
    public function addToAdditionalInformationResult(\StructType\AdditionalInformationResult $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AdditionalInformationResult) {
            throw new \InvalidArgumentException(sprintf('The AdditionalInformationResult property can only contain items of type \StructType\AdditionalInformationResult, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AdditionalInformationResult[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\AdditionalInformationResult|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\AdditionalInformationResult|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\AdditionalInformationResult|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\AdditionalInformationResult|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\AdditionalInformationResult|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string AdditionalInformationResult
     */
    public function getAttributeName()
    {
        return 'AdditionalInformationResult';
    }
}
