<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for size StructType
 * @subpackage Structs
 */
class Size extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The sizeId
     * @var int
     */
    public $sizeId;
    /**
     * The timestamp
     * @var int
     */
    public $timestamp;
    /**
     * Constructor method for size
     * @uses Size::setName()
     * @uses Size::setSizeId()
     * @uses Size::setTimestamp()
     * @param string $name
     * @param int $sizeId
     * @param int $timestamp
     */
    public function __construct($name = null, $sizeId = null, $timestamp = null)
    {
        $this
            ->setName($name)
            ->setSizeId($sizeId)
            ->setTimestamp($timestamp);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\Size
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get sizeId value
     * @return int|null
     */
    public function getSizeId()
    {
        return $this->sizeId;
    }
    /**
     * Set sizeId value
     * @param int $sizeId
     * @return \StructType\Size
     */
    public function setSizeId($sizeId = null)
    {
        // validation for constraint: int
        if (!is_null($sizeId) && !(is_int($sizeId) || ctype_digit($sizeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sizeId, true), gettype($sizeId)), __LINE__);
        }
        $this->sizeId = $sizeId;
        return $this;
    }
    /**
     * Get timestamp value
     * @return int|null
     */
    public function getTimestamp()
    {
        return $this->timestamp;
    }
    /**
     * Set timestamp value
     * @param int $timestamp
     * @return \StructType\Size
     */
    public function setTimestamp($timestamp = null)
    {
        // validation for constraint: int
        if (!is_null($timestamp) && !(is_int($timestamp) || ctype_digit($timestamp))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($timestamp, true), gettype($timestamp)), __LINE__);
        }
        $this->timestamp = $timestamp;
        return $this;
    }
}
