<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for sendSizeColor StructType
 * Meta information extracted from the WSDL
 * - type: tns:sendSizeColor
 * @subpackage Structs
 */
class SendSizeColor extends AbstractStructBase
{
    /**
     * The login
     * @var int
     */
    public $login;
    /**
     * The password
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $password;
    /**
     * The sizeColor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SizeColor
     */
    public $sizeColor;
    /**
     * Constructor method for sendSizeColor
     * @uses SendSizeColor::setLogin()
     * @uses SendSizeColor::setPassword()
     * @uses SendSizeColor::setSizeColor()
     * @param int $login
     * @param string $password
     * @param \StructType\SizeColor $sizeColor
     */
    public function __construct($login = null, $password = null, \StructType\SizeColor $sizeColor = null)
    {
        $this
            ->setLogin($login)
            ->setPassword($password)
            ->setSizeColor($sizeColor);
    }
    /**
     * Get login value
     * @return int|null
     */
    public function getLogin()
    {
        return $this->login;
    }
    /**
     * Set login value
     * @param int $login
     * @return \StructType\SendSizeColor
     */
    public function setLogin($login = null)
    {
        // validation for constraint: int
        if (!is_null($login) && !(is_int($login) || ctype_digit($login))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($login, true), gettype($login)), __LINE__);
        }
        $this->login = $login;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \StructType\SendSizeColor
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get sizeColor value
     * @return \StructType\SizeColor|null
     */
    public function getSizeColor()
    {
        return $this->sizeColor;
    }
    /**
     * Set sizeColor value
     * @param \StructType\SizeColor $sizeColor
     * @return \StructType\SendSizeColor
     */
    public function setSizeColor(\StructType\SizeColor $sizeColor = null)
    {
        $this->sizeColor = $sizeColor;
        return $this;
    }
}
