<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for sendManufacturer StructType
 * Meta information extracted from the WSDL
 * - type: tns:sendManufacturer
 * @subpackage Structs
 */
class SendManufacturer extends AbstractStructBase
{
    /**
     * The login
     * @var int
     */
    public $login;
    /**
     * The password
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $password;
    /**
     * The manufacturer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Manufacturer
     */
    public $manufacturer;
    /**
     * Constructor method for sendManufacturer
     * @uses SendManufacturer::setLogin()
     * @uses SendManufacturer::setPassword()
     * @uses SendManufacturer::setManufacturer()
     * @param int $login
     * @param string $password
     * @param \StructType\Manufacturer $manufacturer
     */
    public function __construct($login = null, $password = null, \StructType\Manufacturer $manufacturer = null)
    {
        $this
            ->setLogin($login)
            ->setPassword($password)
            ->setManufacturer($manufacturer);
    }
    /**
     * Get login value
     * @return int|null
     */
    public function getLogin()
    {
        return $this->login;
    }
    /**
     * Set login value
     * @param int $login
     * @return \StructType\SendManufacturer
     */
    public function setLogin($login = null)
    {
        // validation for constraint: int
        if (!is_null($login) && !(is_int($login) || ctype_digit($login))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($login, true), gettype($login)), __LINE__);
        }
        $this->login = $login;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \StructType\SendManufacturer
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get manufacturer value
     * @return \StructType\Manufacturer|null
     */
    public function getManufacturer()
    {
        return $this->manufacturer;
    }
    /**
     * Set manufacturer value
     * @param \StructType\Manufacturer $manufacturer
     * @return \StructType\SendManufacturer
     */
    public function setManufacturer(\StructType\Manufacturer $manufacturer = null)
    {
        $this->manufacturer = $manufacturer;
        return $this;
    }
}
