<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for sendArticleGroup StructType
 * Meta information extracted from the WSDL
 * - type: tns:sendArticleGroup
 * @subpackage Structs
 */
class SendArticleGroup extends AbstractStructBase
{
    /**
     * The login
     * @var int
     */
    public $login;
    /**
     * The password
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $password;
    /**
     * The articleGroup
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ArticleGroup
     */
    public $articleGroup;
    /**
     * Constructor method for sendArticleGroup
     * @uses SendArticleGroup::setLogin()
     * @uses SendArticleGroup::setPassword()
     * @uses SendArticleGroup::setArticleGroup()
     * @param int $login
     * @param string $password
     * @param \StructType\ArticleGroup $articleGroup
     */
    public function __construct($login = null, $password = null, \StructType\ArticleGroup $articleGroup = null)
    {
        $this
            ->setLogin($login)
            ->setPassword($password)
            ->setArticleGroup($articleGroup);
    }
    /**
     * Get login value
     * @return int|null
     */
    public function getLogin()
    {
        return $this->login;
    }
    /**
     * Set login value
     * @param int $login
     * @return \StructType\SendArticleGroup
     */
    public function setLogin($login = null)
    {
        // validation for constraint: int
        if (!is_null($login) && !(is_int($login) || ctype_digit($login))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($login, true), gettype($login)), __LINE__);
        }
        $this->login = $login;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \StructType\SendArticleGroup
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get articleGroup value
     * @return \StructType\ArticleGroup|null
     */
    public function getArticleGroup()
    {
        return $this->articleGroup;
    }
    /**
     * Set articleGroup value
     * @param \StructType\ArticleGroup $articleGroup
     * @return \StructType\SendArticleGroup
     */
    public function setArticleGroup(\StructType\ArticleGroup $articleGroup = null)
    {
        $this->articleGroup = $articleGroup;
        return $this;
    }
}
