<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for orderLineUpdate StructType
 * @subpackage Structs
 */
class OrderLineUpdate extends AbstractStructBase
{
    /**
     * The amount
     * @var int
     */
    public $amount;
    /**
     * The info
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $info;
    /**
     * The orderLineId
     * @var int
     */
    public $orderLineId;
    /**
     * Constructor method for orderLineUpdate
     * @uses OrderLineUpdate::setAmount()
     * @uses OrderLineUpdate::setInfo()
     * @uses OrderLineUpdate::setOrderLineId()
     * @param int $amount
     * @param string $info
     * @param int $orderLineId
     */
    public function __construct($amount = null, $info = null, $orderLineId = null)
    {
        $this
            ->setAmount($amount)
            ->setInfo($info)
            ->setOrderLineId($orderLineId);
    }
    /**
     * Get amount value
     * @return int|null
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * Set amount value
     * @param int $amount
     * @return \StructType\OrderLineUpdate
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: int
        if (!is_null($amount) && !(is_int($amount) || ctype_digit($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->amount = $amount;
        return $this;
    }
    /**
     * Get info value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInfo()
    {
        return isset($this->info) ? $this->info : null;
    }
    /**
     * Set info value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $info
     * @return \StructType\OrderLineUpdate
     */
    public function setInfo($info = null)
    {
        // validation for constraint: string
        if (!is_null($info) && !is_string($info)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($info, true), gettype($info)), __LINE__);
        }
        if (is_null($info) || (is_array($info) && empty($info))) {
            unset($this->info);
        } else {
            $this->info = $info;
        }
        return $this;
    }
    /**
     * Get orderLineId value
     * @return int|null
     */
    public function getOrderLineId()
    {
        return $this->orderLineId;
    }
    /**
     * Set orderLineId value
     * @param int $orderLineId
     * @return \StructType\OrderLineUpdate
     */
    public function setOrderLineId($orderLineId = null)
    {
        // validation for constraint: int
        if (!is_null($orderLineId) && !(is_int($orderLineId) || ctype_digit($orderLineId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($orderLineId, true), gettype($orderLineId)), __LINE__);
        }
        $this->orderLineId = $orderLineId;
        return $this;
    }
}
