<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for insertUpdateResponse StructType
 * @subpackage Structs
 */
class InsertUpdateResponse extends AbstractStructBase
{
    /**
     * The deltaId
     * @var int
     */
    public $deltaId;
    /**
     * The errorHelpLink
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $errorHelpLink;
    /**
     * The errorMessage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $errorMessage;
    /**
     * The humanErrorMessage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $humanErrorMessage;
    /**
     * The operationResult
     * @var int
     */
    public $operationResult;
    /**
     * Constructor method for insertUpdateResponse
     * @uses InsertUpdateResponse::setDeltaId()
     * @uses InsertUpdateResponse::setErrorHelpLink()
     * @uses InsertUpdateResponse::setErrorMessage()
     * @uses InsertUpdateResponse::setHumanErrorMessage()
     * @uses InsertUpdateResponse::setOperationResult()
     * @param int $deltaId
     * @param string $errorHelpLink
     * @param string $errorMessage
     * @param string $humanErrorMessage
     * @param int $operationResult
     */
    public function __construct($deltaId = null, $errorHelpLink = null, $errorMessage = null, $humanErrorMessage = null, $operationResult = null)
    {
        $this
            ->setDeltaId($deltaId)
            ->setErrorHelpLink($errorHelpLink)
            ->setErrorMessage($errorMessage)
            ->setHumanErrorMessage($humanErrorMessage)
            ->setOperationResult($operationResult);
    }
    /**
     * Get deltaId value
     * @return int|null
     */
    public function getDeltaId()
    {
        return $this->deltaId;
    }
    /**
     * Set deltaId value
     * @param int $deltaId
     * @return \StructType\InsertUpdateResponse
     */
    public function setDeltaId($deltaId = null)
    {
        // validation for constraint: int
        if (!is_null($deltaId) && !(is_int($deltaId) || ctype_digit($deltaId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($deltaId, true), gettype($deltaId)), __LINE__);
        }
        $this->deltaId = $deltaId;
        return $this;
    }
    /**
     * Get errorHelpLink value
     * @return string|null
     */
    public function getErrorHelpLink()
    {
        return $this->errorHelpLink;
    }
    /**
     * Set errorHelpLink value
     * @param string $errorHelpLink
     * @return \StructType\InsertUpdateResponse
     */
    public function setErrorHelpLink($errorHelpLink = null)
    {
        // validation for constraint: string
        if (!is_null($errorHelpLink) && !is_string($errorHelpLink)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorHelpLink, true), gettype($errorHelpLink)), __LINE__);
        }
        $this->errorHelpLink = $errorHelpLink;
        return $this;
    }
    /**
     * Get errorMessage value
     * @return string|null
     */
    public function getErrorMessage()
    {
        return $this->errorMessage;
    }
    /**
     * Set errorMessage value
     * @param string $errorMessage
     * @return \StructType\InsertUpdateResponse
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorMessage, true), gettype($errorMessage)), __LINE__);
        }
        $this->errorMessage = $errorMessage;
        return $this;
    }
    /**
     * Get humanErrorMessage value
     * @return string|null
     */
    public function getHumanErrorMessage()
    {
        return $this->humanErrorMessage;
    }
    /**
     * Set humanErrorMessage value
     * @param string $humanErrorMessage
     * @return \StructType\InsertUpdateResponse
     */
    public function setHumanErrorMessage($humanErrorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($humanErrorMessage) && !is_string($humanErrorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($humanErrorMessage, true), gettype($humanErrorMessage)), __LINE__);
        }
        $this->humanErrorMessage = $humanErrorMessage;
        return $this;
    }
    /**
     * Get operationResult value
     * @return int|null
     */
    public function getOperationResult()
    {
        return $this->operationResult;
    }
    /**
     * Set operationResult value
     * @param int $operationResult
     * @return \StructType\InsertUpdateResponse
     */
    public function setOperationResult($operationResult = null)
    {
        // validation for constraint: int
        if (!is_null($operationResult) && !(is_int($operationResult) || ctype_digit($operationResult))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($operationResult, true), gettype($operationResult)), __LINE__);
        }
        $this->operationResult = $operationResult;
        return $this;
    }
}
