<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for greet StructType
 * Meta information extracted from the WSDL
 * - type: tns:greet
 * @subpackage Structs
 */
class Greet extends AbstractStructBase
{
    /**
     * The login
     * @var int
     */
    public $login;
    /**
     * The password
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $password;
    /**
     * The echoString
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $echoString;
    /**
     * Constructor method for greet
     * @uses Greet::setLogin()
     * @uses Greet::setPassword()
     * @uses Greet::setEchoString()
     * @param int $login
     * @param string $password
     * @param string $echoString
     */
    public function __construct($login = null, $password = null, $echoString = null)
    {
        $this
            ->setLogin($login)
            ->setPassword($password)
            ->setEchoString($echoString);
    }
    /**
     * Get login value
     * @return int|null
     */
    public function getLogin()
    {
        return $this->login;
    }
    /**
     * Set login value
     * @param int $login
     * @return \StructType\Greet
     */
    public function setLogin($login = null)
    {
        // validation for constraint: int
        if (!is_null($login) && !(is_int($login) || ctype_digit($login))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($login, true), gettype($login)), __LINE__);
        }
        $this->login = $login;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \StructType\Greet
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get echoString value
     * @return string|null
     */
    public function getEchoString()
    {
        return $this->echoString;
    }
    /**
     * Set echoString value
     * @param string $echoString
     * @return \StructType\Greet
     */
    public function setEchoString($echoString = null)
    {
        // validation for constraint: string
        if (!is_null($echoString) && !is_string($echoString)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($echoString, true), gettype($echoString)), __LINE__);
        }
        $this->echoString = $echoString;
        return $this;
    }
}
