<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getPaymentTypesResponse StructType
 * @subpackage Structs
 */
class GetPaymentTypesResponse extends AbstractStructBase
{
    /**
     * The insertUpdate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\InsertUpdateResponse
     */
    public $insertUpdate;
    /**
     * The payments
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PaymentType[]
     */
    public $payments;
    /**
     * Constructor method for getPaymentTypesResponse
     * @uses GetPaymentTypesResponse::setInsertUpdate()
     * @uses GetPaymentTypesResponse::setPayments()
     * @param \StructType\InsertUpdateResponse $insertUpdate
     * @param \StructType\PaymentType[] $payments
     */
    public function __construct(\StructType\InsertUpdateResponse $insertUpdate = null, array $payments = array())
    {
        $this
            ->setInsertUpdate($insertUpdate)
            ->setPayments($payments);
    }
    /**
     * Get insertUpdate value
     * @return \StructType\InsertUpdateResponse|null
     */
    public function getInsertUpdate()
    {
        return $this->insertUpdate;
    }
    /**
     * Set insertUpdate value
     * @param \StructType\InsertUpdateResponse $insertUpdate
     * @return \StructType\GetPaymentTypesResponse
     */
    public function setInsertUpdate(\StructType\InsertUpdateResponse $insertUpdate = null)
    {
        $this->insertUpdate = $insertUpdate;
        return $this;
    }
    /**
     * Get payments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PaymentType[]|null
     */
    public function getPayments()
    {
        return isset($this->payments) ? $this->payments : null;
    }
    /**
     * This method is responsible for validating the values passed to the setPayments method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPayments method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaymentsForArrayConstraintsFromSetPayments(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $getPaymentTypesResponsePaymentsItem) {
            // validation for constraint: itemType
            if (!$getPaymentTypesResponsePaymentsItem instanceof \StructType\PaymentType) {
                $invalidValues[] = is_object($getPaymentTypesResponsePaymentsItem) ? get_class($getPaymentTypesResponsePaymentsItem) : sprintf('%s(%s)', gettype($getPaymentTypesResponsePaymentsItem), var_export($getPaymentTypesResponsePaymentsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The payments property can only contain items of type \StructType\PaymentType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set payments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentType[] $payments
     * @return \StructType\GetPaymentTypesResponse
     */
    public function setPayments(array $payments = array())
    {
        // validation for constraint: array
        if ('' !== ($paymentsArrayErrorMessage = self::validatePaymentsForArrayConstraintsFromSetPayments($payments))) {
            throw new \InvalidArgumentException($paymentsArrayErrorMessage, __LINE__);
        }
        if (is_null($payments) || (is_array($payments) && empty($payments))) {
            unset($this->payments);
        } else {
            $this->payments = $payments;
        }
        return $this;
    }
    /**
     * Add item to payments value
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentType $item
     * @return \StructType\GetPaymentTypesResponse
     */
    public function addToPayments(\StructType\PaymentType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PaymentType) {
            throw new \InvalidArgumentException(sprintf('The payments property can only contain items of type \StructType\PaymentType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->payments[] = $item;
        return $this;
    }
}
