<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for deliveredItemsAndCapturedPaymentInfo StructType
 * @subpackage Structs
 */
class DeliveredItemsAndCapturedPaymentInfo extends AbstractStructBase
{
    /**
     * The amount
     * @var float
     */
    public $amount;
    /**
     * The authorzationId
     * @var string
     */
    public $authorzationId;
    /**
     * The extraCost
     * @var float
     */
    public $extraCost;
    /**
     * The freightCost
     * @var float
     */
    public $freightCost;
    /**
     * The paymentMethod
     * @var string
     */
    public $paymentMethod;
    /**
     * Constructor method for deliveredItemsAndCapturedPaymentInfo
     * @uses DeliveredItemsAndCapturedPaymentInfo::setAmount()
     * @uses DeliveredItemsAndCapturedPaymentInfo::setAuthorzationId()
     * @uses DeliveredItemsAndCapturedPaymentInfo::setExtraCost()
     * @uses DeliveredItemsAndCapturedPaymentInfo::setFreightCost()
     * @uses DeliveredItemsAndCapturedPaymentInfo::setPaymentMethod()
     * @param float $amount
     * @param string $authorzationId
     * @param float $extraCost
     * @param float $freightCost
     * @param string $paymentMethod
     */
    public function __construct($amount = null, $authorzationId = null, $extraCost = null, $freightCost = null, $paymentMethod = null)
    {
        $this
            ->setAmount($amount)
            ->setAuthorzationId($authorzationId)
            ->setExtraCost($extraCost)
            ->setFreightCost($freightCost)
            ->setPaymentMethod($paymentMethod);
    }
    /**
     * Get amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * Set amount value
     * @param float $amount
     * @return \StructType\DeliveredItemsAndCapturedPaymentInfo
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->amount = $amount;
        return $this;
    }
    /**
     * Get authorzationId value
     * @return string|null
     */
    public function getAuthorzationId()
    {
        return $this->authorzationId;
    }
    /**
     * Set authorzationId value
     * @param string $authorzationId
     * @return \StructType\DeliveredItemsAndCapturedPaymentInfo
     */
    public function setAuthorzationId($authorzationId = null)
    {
        // validation for constraint: string
        if (!is_null($authorzationId) && !is_string($authorzationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authorzationId, true), gettype($authorzationId)), __LINE__);
        }
        $this->authorzationId = $authorzationId;
        return $this;
    }
    /**
     * Get extraCost value
     * @return float|null
     */
    public function getExtraCost()
    {
        return $this->extraCost;
    }
    /**
     * Set extraCost value
     * @param float $extraCost
     * @return \StructType\DeliveredItemsAndCapturedPaymentInfo
     */
    public function setExtraCost($extraCost = null)
    {
        // validation for constraint: float
        if (!is_null($extraCost) && !(is_float($extraCost) || is_numeric($extraCost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($extraCost, true), gettype($extraCost)), __LINE__);
        }
        $this->extraCost = $extraCost;
        return $this;
    }
    /**
     * Get freightCost value
     * @return float|null
     */
    public function getFreightCost()
    {
        return $this->freightCost;
    }
    /**
     * Set freightCost value
     * @param float $freightCost
     * @return \StructType\DeliveredItemsAndCapturedPaymentInfo
     */
    public function setFreightCost($freightCost = null)
    {
        // validation for constraint: float
        if (!is_null($freightCost) && !(is_float($freightCost) || is_numeric($freightCost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($freightCost, true), gettype($freightCost)), __LINE__);
        }
        $this->freightCost = $freightCost;
        return $this;
    }
    /**
     * Get paymentMethod value
     * @return string|null
     */
    public function getPaymentMethod()
    {
        return $this->paymentMethod;
    }
    /**
     * Set paymentMethod value
     * @param string $paymentMethod
     * @return \StructType\DeliveredItemsAndCapturedPaymentInfo
     */
    public function setPaymentMethod($paymentMethod = null)
    {
        // validation for constraint: string
        if (!is_null($paymentMethod) && !is_string($paymentMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentMethod, true), gettype($paymentMethod)), __LINE__);
        }
        $this->paymentMethod = $paymentMethod;
        return $this;
    }
}
