<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Remove ServiceType
 * @subpackage Services
 */
class Remove extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named removeAricle
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RemoveAricle $parameters
     * @return \StructType\RemoveAricleResponse|bool
     */
    public function removeAricle(\StructType\RemoveAricle $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->removeAricle($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeArticle
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RemoveArticle $parameters
     * @return \StructType\RemoveArticleResponse|bool
     */
    public function removeArticle(\StructType\RemoveArticle $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->removeArticle($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\RemoveAricleResponse|\StructType\RemoveArticleResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
