<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Credit ServiceType
 * @subpackage Services
 */
class Credit extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named creditOrder
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreditOrder $parameters
     * @return \StructType\CreditOrderResponse|bool
     */
    public function creditOrder(\StructType\CreditOrder $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->creditOrder($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\CreditOrderResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
