<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://webshop.deltasoft.no/DeltaWebshop/WS/WebshopWS?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://webshop.deltasoft.no/DeltaWebshop/WS/WebshopWS?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Send ServiceType
 */
$send = new \ServiceType\Send($options);
/**
 * Sample call for sendImageColor operation/method
 */
if ($send->sendImageColor(new \StructType\SendImageColor()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
/**
 * Sample call for sendColor operation/method
 */
if ($send->sendColor(new \StructType\SendColor()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
/**
 * Sample call for sendSize operation/method
 */
if ($send->sendSize(new \StructType\SendSize()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
/**
 * Sample call for sendImage operation/method
 */
if ($send->sendImage(new \StructType\SendImage()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
/**
 * Sample call for sendArticle operation/method
 */
if ($send->sendArticle(new \StructType\SendArticle()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
/**
 * Sample call for sendDiscount operation/method
 */
if ($send->sendDiscount(new \StructType\SendDiscount()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
/**
 * Sample call for sendArticleGroup operation/method
 */
if ($send->sendArticleGroup(new \StructType\SendArticleGroup()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
/**
 * Sample call for sendProductLine operation/method
 */
if ($send->sendProductLine(new \StructType\SendProductLine()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
/**
 * Sample call for sendCustomerGroup operation/method
 */
if ($send->sendCustomerGroup(new \StructType\SendCustomerGroup()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
/**
 * Sample call for sendCustomerInfo operation/method
 */
if ($send->sendCustomerInfo(new \StructType\SendCustomerInfo()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
/**
 * Sample call for sendSizeColor operation/method
 */
if ($send->sendSizeColor(new \StructType\SendSizeColor()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
/**
 * Sample call for sendManufacturer operation/method
 */
if ($send->sendManufacturer(new \StructType\SendManufacturer()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
/**
 * Samples for Update ServiceType
 */
$update = new \ServiceType\Update($options);
/**
 * Sample call for updatePackageInfo operation/method
 */
if ($update->updatePackageInfo(new \StructType\UpdatePackageInfo()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateOrderStatus operation/method
 */
if ($update->updateOrderStatus(new \StructType\UpdateOrderStatus()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateStockCount operation/method
 */
if ($update->updateStockCount(new \StructType\UpdateStockCount()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
/**
 * Sample call for getOrders operation/method
 */
if ($get->getOrders(new \StructType\GetOrders()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getCreditApplicants operation/method
 */
if ($get->getCreditApplicants(new \StructType\GetCreditApplicants()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getWelcomeMailTemplate operation/method
 */
if ($get->getWelcomeMailTemplate(new \StructType\GetWelcomeMailTemplate()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getAllPaymentTypes operation/method
 */
if ($get->getAllPaymentTypes(new \StructType\GetAllPaymentTypes()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getReceiptURL operation/method
 */
if ($get->getReceiptURL(new \StructType\GetReceiptURL()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getArticleURL operation/method
 */
if ($get->getArticleURL(new \StructType\GetArticleURL()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getOrderInfoURL operation/method
 */
if ($get->getOrderInfoURL(new \StructType\GetOrderInfoURL()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getStatus operation/method
 */
if ($get->getStatus(new \StructType\GetStatus()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Greet ServiceType
 */
$greet = new \ServiceType\Greet($options);
/**
 * Sample call for greet operation/method
 */
if ($greet->greet(new \StructType\Greet()) !== false) {
    print_r($greet->getResult());
} else {
    print_r($greet->getLastError());
}
/**
 * Samples for Remove ServiceType
 */
$remove = new \ServiceType\Remove($options);
/**
 * Sample call for removeAricle operation/method
 */
if ($remove->removeAricle(new \StructType\RemoveAricle()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeArticle operation/method
 */
if ($remove->removeArticle(new \StructType\RemoveArticle()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Samples for Credit ServiceType
 */
$credit = new \ServiceType\Credit($options);
/**
 * Sample call for creditOrder operation/method
 */
if ($credit->creditOrder(new \StructType\CreditOrder()) !== false) {
    print_r($credit->getResult());
} else {
    print_r($credit->getLastError());
}
/**
 * Samples for Change ServiceType
 */
$change = new \ServiceType\Change($options);
/**
 * Sample call for changeOrderLine operation/method
 */
if ($change->changeOrderLine(new \StructType\ChangeOrderLine()) !== false) {
    print_r($change->getResult());
} else {
    print_r($change->getLastError());
}
/**
 * Samples for Create ServiceType
 */
$create = new \ServiceType\Create($options);
/**
 * Sample call for createWebshop operation/method
 */
if ($create->createWebshop(new \StructType\CreateWebshop()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
