<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for sendSize StructType
 * Meta information extracted from the WSDL
 * - type: tns:sendSize
 * @subpackage Structs
 */
class SendSize extends AbstractStructBase
{
    /**
     * The login
     * @var int
     */
    public $login;
    /**
     * The password
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $password;
    /**
     * The size
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Size
     */
    public $size;
    /**
     * Constructor method for sendSize
     * @uses SendSize::setLogin()
     * @uses SendSize::setPassword()
     * @uses SendSize::setSize()
     * @param int $login
     * @param string $password
     * @param \StructType\Size $size
     */
    public function __construct($login = null, $password = null, \StructType\Size $size = null)
    {
        $this
            ->setLogin($login)
            ->setPassword($password)
            ->setSize($size);
    }
    /**
     * Get login value
     * @return int|null
     */
    public function getLogin()
    {
        return $this->login;
    }
    /**
     * Set login value
     * @param int $login
     * @return \StructType\SendSize
     */
    public function setLogin($login = null)
    {
        // validation for constraint: int
        if (!is_null($login) && !(is_int($login) || ctype_digit($login))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($login, true), gettype($login)), __LINE__);
        }
        $this->login = $login;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \StructType\SendSize
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get size value
     * @return \StructType\Size|null
     */
    public function getSize()
    {
        return $this->size;
    }
    /**
     * Set size value
     * @param \StructType\Size $size
     * @return \StructType\SendSize
     */
    public function setSize(\StructType\Size $size = null)
    {
        $this->size = $size;
        return $this;
    }
}
