<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for sendImage StructType
 * Meta information extracted from the WSDL
 * - type: tns:sendImage
 * @subpackage Structs
 */
class SendImage extends AbstractStructBase
{
    /**
     * The login
     * @var int
     */
    public $login;
    /**
     * The password
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $password;
    /**
     * The image
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $image;
    /**
     * The articleid
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $articleid;
    /**
     * Constructor method for sendImage
     * @uses SendImage::setLogin()
     * @uses SendImage::setPassword()
     * @uses SendImage::setImage()
     * @uses SendImage::setArticleid()
     * @param int $login
     * @param string $password
     * @param string $image
     * @param int $articleid
     */
    public function __construct($login = null, $password = null, $image = null, $articleid = null)
    {
        $this
            ->setLogin($login)
            ->setPassword($password)
            ->setImage($image)
            ->setArticleid($articleid);
    }
    /**
     * Get login value
     * @return int|null
     */
    public function getLogin()
    {
        return $this->login;
    }
    /**
     * Set login value
     * @param int $login
     * @return \StructType\SendImage
     */
    public function setLogin($login = null)
    {
        // validation for constraint: int
        if (!is_null($login) && !(is_int($login) || ctype_digit($login))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($login, true), gettype($login)), __LINE__);
        }
        $this->login = $login;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \StructType\SendImage
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get image value
     * @return string|null
     */
    public function getImage()
    {
        return $this->image;
    }
    /**
     * Set image value
     * @param string $image
     * @return \StructType\SendImage
     */
    public function setImage($image = null)
    {
        // validation for constraint: string
        if (!is_null($image) && !is_string($image)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($image, true), gettype($image)), __LINE__);
        }
        $this->image = $image;
        return $this;
    }
    /**
     * Get articleid value
     * @return int|null
     */
    public function getArticleid()
    {
        return $this->articleid;
    }
    /**
     * Set articleid value
     * @param int $articleid
     * @return \StructType\SendImage
     */
    public function setArticleid($articleid = null)
    {
        // validation for constraint: int
        if (!is_null($articleid) && !(is_int($articleid) || ctype_digit($articleid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($articleid, true), gettype($articleid)), __LINE__);
        }
        $this->articleid = $articleid;
        return $this;
    }
}
