<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for sendCustomerInfo StructType
 * Meta information extracted from the WSDL
 * - type: tns:sendCustomerInfo
 * @subpackage Structs
 */
class SendCustomerInfo extends AbstractStructBase
{
    /**
     * The login
     * @var int
     */
    public $login;
    /**
     * The password
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $password;
    /**
     * The customerInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomerInfo
     */
    public $customerInfo;
    /**
     * Constructor method for sendCustomerInfo
     * @uses SendCustomerInfo::setLogin()
     * @uses SendCustomerInfo::setPassword()
     * @uses SendCustomerInfo::setCustomerInfo()
     * @param int $login
     * @param string $password
     * @param \StructType\CustomerInfo $customerInfo
     */
    public function __construct($login = null, $password = null, \StructType\CustomerInfo $customerInfo = null)
    {
        $this
            ->setLogin($login)
            ->setPassword($password)
            ->setCustomerInfo($customerInfo);
    }
    /**
     * Get login value
     * @return int|null
     */
    public function getLogin()
    {
        return $this->login;
    }
    /**
     * Set login value
     * @param int $login
     * @return \StructType\SendCustomerInfo
     */
    public function setLogin($login = null)
    {
        // validation for constraint: int
        if (!is_null($login) && !(is_int($login) || ctype_digit($login))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($login, true), gettype($login)), __LINE__);
        }
        $this->login = $login;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \StructType\SendCustomerInfo
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get customerInfo value
     * @return \StructType\CustomerInfo|null
     */
    public function getCustomerInfo()
    {
        return $this->customerInfo;
    }
    /**
     * Set customerInfo value
     * @param \StructType\CustomerInfo $customerInfo
     * @return \StructType\SendCustomerInfo
     */
    public function setCustomerInfo(\StructType\CustomerInfo $customerInfo = null)
    {
        $this->customerInfo = $customerInfo;
        return $this;
    }
}
