<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for orderLine StructType
 * @subpackage Structs
 */
class OrderLine extends AbstractStructBase
{
    /**
     * The articleId
     * @var int
     */
    public $articleId;
    /**
     * The count
     * @var int
     */
    public $count;
    /**
     * The discount
     * @var float
     */
    public $discount;
    /**
     * The info
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $info;
    /**
     * The orderLineId
     * @var int
     */
    public $orderLineId;
    /**
     * The price
     * @var float
     */
    public $price;
    /**
     * The sizeColorId
     * @var int
     */
    public $sizeColorId;
    /**
     * The warehouseId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $warehouseId;
    /**
     * Constructor method for orderLine
     * @uses OrderLine::setArticleId()
     * @uses OrderLine::setCount()
     * @uses OrderLine::setDiscount()
     * @uses OrderLine::setInfo()
     * @uses OrderLine::setOrderLineId()
     * @uses OrderLine::setPrice()
     * @uses OrderLine::setSizeColorId()
     * @uses OrderLine::setWarehouseId()
     * @param int $articleId
     * @param int $count
     * @param float $discount
     * @param string $info
     * @param int $orderLineId
     * @param float $price
     * @param int $sizeColorId
     * @param int $warehouseId
     */
    public function __construct($articleId = null, $count = null, $discount = null, $info = null, $orderLineId = null, $price = null, $sizeColorId = null, $warehouseId = null)
    {
        $this
            ->setArticleId($articleId)
            ->setCount($count)
            ->setDiscount($discount)
            ->setInfo($info)
            ->setOrderLineId($orderLineId)
            ->setPrice($price)
            ->setSizeColorId($sizeColorId)
            ->setWarehouseId($warehouseId);
    }
    /**
     * Get articleId value
     * @return int|null
     */
    public function getArticleId()
    {
        return $this->articleId;
    }
    /**
     * Set articleId value
     * @param int $articleId
     * @return \StructType\OrderLine
     */
    public function setArticleId($articleId = null)
    {
        // validation for constraint: int
        if (!is_null($articleId) && !(is_int($articleId) || ctype_digit($articleId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($articleId, true), gettype($articleId)), __LINE__);
        }
        $this->articleId = $articleId;
        return $this;
    }
    /**
     * Get count value
     * @return int|null
     */
    public function getCount()
    {
        return $this->count;
    }
    /**
     * Set count value
     * @param int $count
     * @return \StructType\OrderLine
     */
    public function setCount($count = null)
    {
        // validation for constraint: int
        if (!is_null($count) && !(is_int($count) || ctype_digit($count))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($count, true), gettype($count)), __LINE__);
        }
        $this->count = $count;
        return $this;
    }
    /**
     * Get discount value
     * @return float|null
     */
    public function getDiscount()
    {
        return $this->discount;
    }
    /**
     * Set discount value
     * @param float $discount
     * @return \StructType\OrderLine
     */
    public function setDiscount($discount = null)
    {
        // validation for constraint: float
        if (!is_null($discount) && !(is_float($discount) || is_numeric($discount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($discount, true), gettype($discount)), __LINE__);
        }
        $this->discount = $discount;
        return $this;
    }
    /**
     * Get info value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInfo()
    {
        return isset($this->info) ? $this->info : null;
    }
    /**
     * Set info value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $info
     * @return \StructType\OrderLine
     */
    public function setInfo($info = null)
    {
        // validation for constraint: string
        if (!is_null($info) && !is_string($info)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($info, true), gettype($info)), __LINE__);
        }
        if (is_null($info) || (is_array($info) && empty($info))) {
            unset($this->info);
        } else {
            $this->info = $info;
        }
        return $this;
    }
    /**
     * Get orderLineId value
     * @return int|null
     */
    public function getOrderLineId()
    {
        return $this->orderLineId;
    }
    /**
     * Set orderLineId value
     * @param int $orderLineId
     * @return \StructType\OrderLine
     */
    public function setOrderLineId($orderLineId = null)
    {
        // validation for constraint: int
        if (!is_null($orderLineId) && !(is_int($orderLineId) || ctype_digit($orderLineId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($orderLineId, true), gettype($orderLineId)), __LINE__);
        }
        $this->orderLineId = $orderLineId;
        return $this;
    }
    /**
     * Get price value
     * @return float|null
     */
    public function getPrice()
    {
        return $this->price;
    }
    /**
     * Set price value
     * @param float $price
     * @return \StructType\OrderLine
     */
    public function setPrice($price = null)
    {
        // validation for constraint: float
        if (!is_null($price) && !(is_float($price) || is_numeric($price))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($price, true), gettype($price)), __LINE__);
        }
        $this->price = $price;
        return $this;
    }
    /**
     * Get sizeColorId value
     * @return int|null
     */
    public function getSizeColorId()
    {
        return $this->sizeColorId;
    }
    /**
     * Set sizeColorId value
     * @param int $sizeColorId
     * @return \StructType\OrderLine
     */
    public function setSizeColorId($sizeColorId = null)
    {
        // validation for constraint: int
        if (!is_null($sizeColorId) && !(is_int($sizeColorId) || ctype_digit($sizeColorId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sizeColorId, true), gettype($sizeColorId)), __LINE__);
        }
        $this->sizeColorId = $sizeColorId;
        return $this;
    }
    /**
     * Get warehouseId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getWarehouseId()
    {
        return isset($this->warehouseId) ? $this->warehouseId : null;
    }
    /**
     * Set warehouseId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $warehouseId
     * @return \StructType\OrderLine
     */
    public function setWarehouseId($warehouseId = null)
    {
        // validation for constraint: int
        if (!is_null($warehouseId) && !(is_int($warehouseId) || ctype_digit($warehouseId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($warehouseId, true), gettype($warehouseId)), __LINE__);
        }
        if (is_null($warehouseId) || (is_array($warehouseId) && empty($warehouseId))) {
            unset($this->warehouseId);
        } else {
            $this->warehouseId = $warehouseId;
        }
        return $this;
    }
}
