<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for creditApplicantsReturn StructType
 * @subpackage Structs
 */
class CreditApplicantsReturn extends AbstractStructBase
{
    /**
     * The insertUpdate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\InsertUpdateResponse
     */
    public $insertUpdate;
    /**
     * The listCustomers
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Customer[]
     */
    public $listCustomers;
    /**
     * Constructor method for creditApplicantsReturn
     * @uses CreditApplicantsReturn::setInsertUpdate()
     * @uses CreditApplicantsReturn::setListCustomers()
     * @param \StructType\InsertUpdateResponse $insertUpdate
     * @param \StructType\Customer[] $listCustomers
     */
    public function __construct(\StructType\InsertUpdateResponse $insertUpdate = null, array $listCustomers = array())
    {
        $this
            ->setInsertUpdate($insertUpdate)
            ->setListCustomers($listCustomers);
    }
    /**
     * Get insertUpdate value
     * @return \StructType\InsertUpdateResponse|null
     */
    public function getInsertUpdate()
    {
        return $this->insertUpdate;
    }
    /**
     * Set insertUpdate value
     * @param \StructType\InsertUpdateResponse $insertUpdate
     * @return \StructType\CreditApplicantsReturn
     */
    public function setInsertUpdate(\StructType\InsertUpdateResponse $insertUpdate = null)
    {
        $this->insertUpdate = $insertUpdate;
        return $this;
    }
    /**
     * Get listCustomers value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Customer[]|null
     */
    public function getListCustomers()
    {
        return isset($this->listCustomers) ? $this->listCustomers : null;
    }
    /**
     * This method is responsible for validating the values passed to the setListCustomers method
     * This method is willingly generated in order to preserve the one-line inline validation within the setListCustomers method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateListCustomersForArrayConstraintsFromSetListCustomers(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $creditApplicantsReturnListCustomersItem) {
            // validation for constraint: itemType
            if (!$creditApplicantsReturnListCustomersItem instanceof \StructType\Customer) {
                $invalidValues[] = is_object($creditApplicantsReturnListCustomersItem) ? get_class($creditApplicantsReturnListCustomersItem) : sprintf('%s(%s)', gettype($creditApplicantsReturnListCustomersItem), var_export($creditApplicantsReturnListCustomersItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The listCustomers property can only contain items of type \StructType\Customer, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set listCustomers value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Customer[] $listCustomers
     * @return \StructType\CreditApplicantsReturn
     */
    public function setListCustomers(array $listCustomers = array())
    {
        // validation for constraint: array
        if ('' !== ($listCustomersArrayErrorMessage = self::validateListCustomersForArrayConstraintsFromSetListCustomers($listCustomers))) {
            throw new \InvalidArgumentException($listCustomersArrayErrorMessage, __LINE__);
        }
        if (is_null($listCustomers) || (is_array($listCustomers) && empty($listCustomers))) {
            unset($this->listCustomers);
        } else {
            $this->listCustomers = $listCustomers;
        }
        return $this;
    }
    /**
     * Add item to listCustomers value
     * @throws \InvalidArgumentException
     * @param \StructType\Customer $item
     * @return \StructType\CreditApplicantsReturn
     */
    public function addToListCustomers(\StructType\Customer $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Customer) {
            throw new \InvalidArgumentException(sprintf('The listCustomers property can only contain items of type \StructType\Customer, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->listCustomers[] = $item;
        return $this;
    }
}
