<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for article StructType
 * @subpackage Structs
 */
class Article extends AbstractStructBase
{
    /**
     * The alternativePrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $alternativePrice;
    /**
     * The alternativePrice2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $alternativePrice2;
    /**
     * The alternativeVat
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $alternativeVat;
    /**
     * The alternatives
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Alternative[]
     */
    public $alternatives;
    /**
     * The articleGroup
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ArticleGroup
     */
    public $articleGroup;
    /**
     * The articleGroup2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ArticleGroup
     */
    public $articleGroup2;
    /**
     * The articleGroup3
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ArticleGroup
     */
    public $articleGroup3;
    /**
     * The articleId
     * @var int
     */
    public $articleId;
    /**
     * The articleNo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $articleNo;
    /**
     * The articleStatus
     * @var int
     */
    public $articleStatus;
    /**
     * The articleWebAction
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $articleWebAction;
    /**
     * The autoOpenAlternatives
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $autoOpenAlternatives;
    /**
     * The confirmedDelivery
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var bool
     */
    public $confirmedDelivery;
    /**
     * The costPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $costPrice;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The discount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $discount;
    /**
     * The discountFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $discountFrom;
    /**
     * The discountTo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $discountTo;
    /**
     * The eans
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $eans;
    /**
     * The expectedDeliveryAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $expectedDeliveryAmount;
    /**
     * The expectedDeliveryDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $expectedDeliveryDate;
    /**
     * The externalGroupId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $externalGroupId;
    /**
     * The externalGroupId2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $externalGroupId2;
    /**
     * The externalLink
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $externalLink;
    /**
     * The height
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $height;
    /**
     * The hideWhenOutOfStock
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $hideWhenOutOfStock;
    /**
     * The info1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $info1;
    /**
     * The info2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $info2;
    /**
     * The info3
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $info3;
    /**
     * The length
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $length;
    /**
     * The manufacturer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Manufacturer
     */
    public $manufacturer;
    /**
     * The manufacturerArticleNo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $manufacturerArticleNo;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The noDiscount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $noDiscount;
    /**
     * The nonStockItem
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $nonStockItem;
    /**
     * The nonStockItemDays
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $nonStockItemDays;
    /**
     * The price1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $price1;
    /**
     * The price10
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $price10;
    /**
     * The price2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $price2;
    /**
     * The price3
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $price3;
    /**
     * The price4
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $price4;
    /**
     * The price5
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $price5;
    /**
     * The price6
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $price6;
    /**
     * The price7
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $price7;
    /**
     * The price8
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $price8;
    /**
     * The price9
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $price9;
    /**
     * The productLine
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ProductLine
     */
    public $productLine;
    /**
     * The purchasePrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $purchasePrice;
    /**
     * The recommendedProduct
     * @var bool
     */
    public $recommendedProduct;
    /**
     * The salesPrice
     * @var float
     */
    public $salesPrice;
    /**
     * The shippingType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $shippingType;
    /**
     * The sizeColorInUse
     * @var bool
     */
    public $sizeColorInUse;
    /**
     * The sizeColors
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\SizeColor[]
     */
    public $sizeColors;
    /**
     * The stockCcount
     * @var int
     */
    public $stockCcount;
    /**
     * The stockCount
     * @var int
     */
    public $stockCount;
    /**
     * The stockDetails
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StockDetail[]
     */
    public $stockDetails;
    /**
     * The storePrice
     * @var float
     */
    public $storePrice;
    /**
     * The subtitle
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $subtitle;
    /**
     * The suggestedPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $suggestedPrice;
    /**
     * The timestamp
     * @var int
     */
    public $timestamp;
    /**
     * The vat
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var float
     */
    public $vat;
    /**
     * The visibleOnWeb
     * @var bool
     */
    public $visibleOnWeb;
    /**
     * The volume
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $volume;
    /**
     * The webshippingPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $webshippingPrice;
    /**
     * The webstockLimit
     * @var int
     */
    public $webstockLimit;
    /**
     * The weight
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $weight;
    /**
     * The width
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $width;
    /**
     * Constructor method for article
     * @uses Article::setAlternativePrice()
     * @uses Article::setAlternativePrice2()
     * @uses Article::setAlternativeVat()
     * @uses Article::setAlternatives()
     * @uses Article::setArticleGroup()
     * @uses Article::setArticleGroup2()
     * @uses Article::setArticleGroup3()
     * @uses Article::setArticleId()
     * @uses Article::setArticleNo()
     * @uses Article::setArticleStatus()
     * @uses Article::setArticleWebAction()
     * @uses Article::setAutoOpenAlternatives()
     * @uses Article::setConfirmedDelivery()
     * @uses Article::setCostPrice()
     * @uses Article::setDescription()
     * @uses Article::setDiscount()
     * @uses Article::setDiscountFrom()
     * @uses Article::setDiscountTo()
     * @uses Article::setEans()
     * @uses Article::setExpectedDeliveryAmount()
     * @uses Article::setExpectedDeliveryDate()
     * @uses Article::setExternalGroupId()
     * @uses Article::setExternalGroupId2()
     * @uses Article::setExternalLink()
     * @uses Article::setHeight()
     * @uses Article::setHideWhenOutOfStock()
     * @uses Article::setInfo1()
     * @uses Article::setInfo2()
     * @uses Article::setInfo3()
     * @uses Article::setLength()
     * @uses Article::setManufacturer()
     * @uses Article::setManufacturerArticleNo()
     * @uses Article::setName()
     * @uses Article::setNoDiscount()
     * @uses Article::setNonStockItem()
     * @uses Article::setNonStockItemDays()
     * @uses Article::setPrice1()
     * @uses Article::setPrice10()
     * @uses Article::setPrice2()
     * @uses Article::setPrice3()
     * @uses Article::setPrice4()
     * @uses Article::setPrice5()
     * @uses Article::setPrice6()
     * @uses Article::setPrice7()
     * @uses Article::setPrice8()
     * @uses Article::setPrice9()
     * @uses Article::setProductLine()
     * @uses Article::setPurchasePrice()
     * @uses Article::setRecommendedProduct()
     * @uses Article::setSalesPrice()
     * @uses Article::setShippingType()
     * @uses Article::setSizeColorInUse()
     * @uses Article::setSizeColors()
     * @uses Article::setStockCcount()
     * @uses Article::setStockCount()
     * @uses Article::setStockDetails()
     * @uses Article::setStorePrice()
     * @uses Article::setSubtitle()
     * @uses Article::setSuggestedPrice()
     * @uses Article::setTimestamp()
     * @uses Article::setVat()
     * @uses Article::setVisibleOnWeb()
     * @uses Article::setVolume()
     * @uses Article::setWebshippingPrice()
     * @uses Article::setWebstockLimit()
     * @uses Article::setWeight()
     * @uses Article::setWidth()
     * @param float $alternativePrice
     * @param float $alternativePrice2
     * @param float $alternativeVat
     * @param \StructType\Alternative[] $alternatives
     * @param \StructType\ArticleGroup $articleGroup
     * @param \StructType\ArticleGroup $articleGroup2
     * @param \StructType\ArticleGroup $articleGroup3
     * @param int $articleId
     * @param string $articleNo
     * @param int $articleStatus
     * @param int $articleWebAction
     * @param bool $autoOpenAlternatives
     * @param bool $confirmedDelivery
     * @param float $costPrice
     * @param string $description
     * @param float $discount
     * @param int $discountFrom
     * @param int $discountTo
     * @param string[] $eans
     * @param int $expectedDeliveryAmount
     * @param string $expectedDeliveryDate
     * @param int $externalGroupId
     * @param int $externalGroupId2
     * @param string $externalLink
     * @param float $height
     * @param bool $hideWhenOutOfStock
     * @param string $info1
     * @param string $info2
     * @param string $info3
     * @param float $length
     * @param \StructType\Manufacturer $manufacturer
     * @param string $manufacturerArticleNo
     * @param string $name
     * @param bool $noDiscount
     * @param bool $nonStockItem
     * @param int $nonStockItemDays
     * @param float $price1
     * @param float $price10
     * @param float $price2
     * @param float $price3
     * @param float $price4
     * @param float $price5
     * @param float $price6
     * @param float $price7
     * @param float $price8
     * @param float $price9
     * @param \StructType\ProductLine $productLine
     * @param float $purchasePrice
     * @param bool $recommendedProduct
     * @param float $salesPrice
     * @param int $shippingType
     * @param bool $sizeColorInUse
     * @param \StructType\SizeColor[] $sizeColors
     * @param int $stockCcount
     * @param int $stockCount
     * @param \StructType\StockDetail[] $stockDetails
     * @param float $storePrice
     * @param string $subtitle
     * @param float $suggestedPrice
     * @param int $timestamp
     * @param float $vat
     * @param bool $visibleOnWeb
     * @param float $volume
     * @param float $webshippingPrice
     * @param int $webstockLimit
     * @param float $weight
     * @param float $width
     */
    public function __construct($alternativePrice = null, $alternativePrice2 = null, $alternativeVat = null, array $alternatives = array(), \StructType\ArticleGroup $articleGroup = null, \StructType\ArticleGroup $articleGroup2 = null, \StructType\ArticleGroup $articleGroup3 = null, $articleId = null, $articleNo = null, $articleStatus = null, $articleWebAction = null, $autoOpenAlternatives = null, $confirmedDelivery = null, $costPrice = null, $description = null, $discount = null, $discountFrom = null, $discountTo = null, array $eans = array(), $expectedDeliveryAmount = null, $expectedDeliveryDate = null, $externalGroupId = null, $externalGroupId2 = null, $externalLink = null, $height = null, $hideWhenOutOfStock = null, $info1 = null, $info2 = null, $info3 = null, $length = null, \StructType\Manufacturer $manufacturer = null, $manufacturerArticleNo = null, $name = null, $noDiscount = null, $nonStockItem = null, $nonStockItemDays = null, $price1 = null, $price10 = null, $price2 = null, $price3 = null, $price4 = null, $price5 = null, $price6 = null, $price7 = null, $price8 = null, $price9 = null, \StructType\ProductLine $productLine = null, $purchasePrice = null, $recommendedProduct = null, $salesPrice = null, $shippingType = null, $sizeColorInUse = null, array $sizeColors = array(), $stockCcount = null, $stockCount = null, array $stockDetails = array(), $storePrice = null, $subtitle = null, $suggestedPrice = null, $timestamp = null, $vat = null, $visibleOnWeb = null, $volume = null, $webshippingPrice = null, $webstockLimit = null, $weight = null, $width = null)
    {
        $this
            ->setAlternativePrice($alternativePrice)
            ->setAlternativePrice2($alternativePrice2)
            ->setAlternativeVat($alternativeVat)
            ->setAlternatives($alternatives)
            ->setArticleGroup($articleGroup)
            ->setArticleGroup2($articleGroup2)
            ->setArticleGroup3($articleGroup3)
            ->setArticleId($articleId)
            ->setArticleNo($articleNo)
            ->setArticleStatus($articleStatus)
            ->setArticleWebAction($articleWebAction)
            ->setAutoOpenAlternatives($autoOpenAlternatives)
            ->setConfirmedDelivery($confirmedDelivery)
            ->setCostPrice($costPrice)
            ->setDescription($description)
            ->setDiscount($discount)
            ->setDiscountFrom($discountFrom)
            ->setDiscountTo($discountTo)
            ->setEans($eans)
            ->setExpectedDeliveryAmount($expectedDeliveryAmount)
            ->setExpectedDeliveryDate($expectedDeliveryDate)
            ->setExternalGroupId($externalGroupId)
            ->setExternalGroupId2($externalGroupId2)
            ->setExternalLink($externalLink)
            ->setHeight($height)
            ->setHideWhenOutOfStock($hideWhenOutOfStock)
            ->setInfo1($info1)
            ->setInfo2($info2)
            ->setInfo3($info3)
            ->setLength($length)
            ->setManufacturer($manufacturer)
            ->setManufacturerArticleNo($manufacturerArticleNo)
            ->setName($name)
            ->setNoDiscount($noDiscount)
            ->setNonStockItem($nonStockItem)
            ->setNonStockItemDays($nonStockItemDays)
            ->setPrice1($price1)
            ->setPrice10($price10)
            ->setPrice2($price2)
            ->setPrice3($price3)
            ->setPrice4($price4)
            ->setPrice5($price5)
            ->setPrice6($price6)
            ->setPrice7($price7)
            ->setPrice8($price8)
            ->setPrice9($price9)
            ->setProductLine($productLine)
            ->setPurchasePrice($purchasePrice)
            ->setRecommendedProduct($recommendedProduct)
            ->setSalesPrice($salesPrice)
            ->setShippingType($shippingType)
            ->setSizeColorInUse($sizeColorInUse)
            ->setSizeColors($sizeColors)
            ->setStockCcount($stockCcount)
            ->setStockCount($stockCount)
            ->setStockDetails($stockDetails)
            ->setStorePrice($storePrice)
            ->setSubtitle($subtitle)
            ->setSuggestedPrice($suggestedPrice)
            ->setTimestamp($timestamp)
            ->setVat($vat)
            ->setVisibleOnWeb($visibleOnWeb)
            ->setVolume($volume)
            ->setWebshippingPrice($webshippingPrice)
            ->setWebstockLimit($webstockLimit)
            ->setWeight($weight)
            ->setWidth($width);
    }
    /**
     * Get alternativePrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getAlternativePrice()
    {
        return isset($this->alternativePrice) ? $this->alternativePrice : null;
    }
    /**
     * Set alternativePrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $alternativePrice
     * @return \StructType\Article
     */
    public function setAlternativePrice($alternativePrice = null)
    {
        // validation for constraint: float
        if (!is_null($alternativePrice) && !(is_float($alternativePrice) || is_numeric($alternativePrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($alternativePrice, true), gettype($alternativePrice)), __LINE__);
        }
        if (is_null($alternativePrice) || (is_array($alternativePrice) && empty($alternativePrice))) {
            unset($this->alternativePrice);
        } else {
            $this->alternativePrice = $alternativePrice;
        }
        return $this;
    }
    /**
     * Get alternativePrice2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getAlternativePrice2()
    {
        return isset($this->alternativePrice2) ? $this->alternativePrice2 : null;
    }
    /**
     * Set alternativePrice2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $alternativePrice2
     * @return \StructType\Article
     */
    public function setAlternativePrice2($alternativePrice2 = null)
    {
        // validation for constraint: float
        if (!is_null($alternativePrice2) && !(is_float($alternativePrice2) || is_numeric($alternativePrice2))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($alternativePrice2, true), gettype($alternativePrice2)), __LINE__);
        }
        if (is_null($alternativePrice2) || (is_array($alternativePrice2) && empty($alternativePrice2))) {
            unset($this->alternativePrice2);
        } else {
            $this->alternativePrice2 = $alternativePrice2;
        }
        return $this;
    }
    /**
     * Get alternativeVat value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getAlternativeVat()
    {
        return isset($this->alternativeVat) ? $this->alternativeVat : null;
    }
    /**
     * Set alternativeVat value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $alternativeVat
     * @return \StructType\Article
     */
    public function setAlternativeVat($alternativeVat = null)
    {
        // validation for constraint: float
        if (!is_null($alternativeVat) && !(is_float($alternativeVat) || is_numeric($alternativeVat))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($alternativeVat, true), gettype($alternativeVat)), __LINE__);
        }
        if (is_null($alternativeVat) || (is_array($alternativeVat) && empty($alternativeVat))) {
            unset($this->alternativeVat);
        } else {
            $this->alternativeVat = $alternativeVat;
        }
        return $this;
    }
    /**
     * Get alternatives value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Alternative[]|null
     */
    public function getAlternatives()
    {
        return isset($this->alternatives) ? $this->alternatives : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAlternatives method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAlternatives method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAlternativesForArrayConstraintsFromSetAlternatives(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $articleAlternativesItem) {
            // validation for constraint: itemType
            if (!$articleAlternativesItem instanceof \StructType\Alternative) {
                $invalidValues[] = is_object($articleAlternativesItem) ? get_class($articleAlternativesItem) : sprintf('%s(%s)', gettype($articleAlternativesItem), var_export($articleAlternativesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The alternatives property can only contain items of type \StructType\Alternative, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set alternatives value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Alternative[] $alternatives
     * @return \StructType\Article
     */
    public function setAlternatives(array $alternatives = array())
    {
        // validation for constraint: array
        if ('' !== ($alternativesArrayErrorMessage = self::validateAlternativesForArrayConstraintsFromSetAlternatives($alternatives))) {
            throw new \InvalidArgumentException($alternativesArrayErrorMessage, __LINE__);
        }
        if (is_null($alternatives) || (is_array($alternatives) && empty($alternatives))) {
            unset($this->alternatives);
        } else {
            $this->alternatives = $alternatives;
        }
        return $this;
    }
    /**
     * Add item to alternatives value
     * @throws \InvalidArgumentException
     * @param \StructType\Alternative $item
     * @return \StructType\Article
     */
    public function addToAlternatives(\StructType\Alternative $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Alternative) {
            throw new \InvalidArgumentException(sprintf('The alternatives property can only contain items of type \StructType\Alternative, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->alternatives[] = $item;
        return $this;
    }
    /**
     * Get articleGroup value
     * @return \StructType\ArticleGroup|null
     */
    public function getArticleGroup()
    {
        return $this->articleGroup;
    }
    /**
     * Set articleGroup value
     * @param \StructType\ArticleGroup $articleGroup
     * @return \StructType\Article
     */
    public function setArticleGroup(\StructType\ArticleGroup $articleGroup = null)
    {
        $this->articleGroup = $articleGroup;
        return $this;
    }
    /**
     * Get articleGroup2 value
     * @return \StructType\ArticleGroup|null
     */
    public function getArticleGroup2()
    {
        return $this->articleGroup2;
    }
    /**
     * Set articleGroup2 value
     * @param \StructType\ArticleGroup $articleGroup2
     * @return \StructType\Article
     */
    public function setArticleGroup2(\StructType\ArticleGroup $articleGroup2 = null)
    {
        $this->articleGroup2 = $articleGroup2;
        return $this;
    }
    /**
     * Get articleGroup3 value
     * @return \StructType\ArticleGroup|null
     */
    public function getArticleGroup3()
    {
        return $this->articleGroup3;
    }
    /**
     * Set articleGroup3 value
     * @param \StructType\ArticleGroup $articleGroup3
     * @return \StructType\Article
     */
    public function setArticleGroup3(\StructType\ArticleGroup $articleGroup3 = null)
    {
        $this->articleGroup3 = $articleGroup3;
        return $this;
    }
    /**
     * Get articleId value
     * @return int|null
     */
    public function getArticleId()
    {
        return $this->articleId;
    }
    /**
     * Set articleId value
     * @param int $articleId
     * @return \StructType\Article
     */
    public function setArticleId($articleId = null)
    {
        // validation for constraint: int
        if (!is_null($articleId) && !(is_int($articleId) || ctype_digit($articleId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($articleId, true), gettype($articleId)), __LINE__);
        }
        $this->articleId = $articleId;
        return $this;
    }
    /**
     * Get articleNo value
     * @return string|null
     */
    public function getArticleNo()
    {
        return $this->articleNo;
    }
    /**
     * Set articleNo value
     * @param string $articleNo
     * @return \StructType\Article
     */
    public function setArticleNo($articleNo = null)
    {
        // validation for constraint: string
        if (!is_null($articleNo) && !is_string($articleNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($articleNo, true), gettype($articleNo)), __LINE__);
        }
        $this->articleNo = $articleNo;
        return $this;
    }
    /**
     * Get articleStatus value
     * @return int|null
     */
    public function getArticleStatus()
    {
        return $this->articleStatus;
    }
    /**
     * Set articleStatus value
     * @param int $articleStatus
     * @return \StructType\Article
     */
    public function setArticleStatus($articleStatus = null)
    {
        // validation for constraint: int
        if (!is_null($articleStatus) && !(is_int($articleStatus) || ctype_digit($articleStatus))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($articleStatus, true), gettype($articleStatus)), __LINE__);
        }
        $this->articleStatus = $articleStatus;
        return $this;
    }
    /**
     * Get articleWebAction value
     * @return int|null
     */
    public function getArticleWebAction()
    {
        return $this->articleWebAction;
    }
    /**
     * Set articleWebAction value
     * @param int $articleWebAction
     * @return \StructType\Article
     */
    public function setArticleWebAction($articleWebAction = null)
    {
        // validation for constraint: int
        if (!is_null($articleWebAction) && !(is_int($articleWebAction) || ctype_digit($articleWebAction))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($articleWebAction, true), gettype($articleWebAction)), __LINE__);
        }
        $this->articleWebAction = $articleWebAction;
        return $this;
    }
    /**
     * Get autoOpenAlternatives value
     * @return bool|null
     */
    public function getAutoOpenAlternatives()
    {
        return $this->autoOpenAlternatives;
    }
    /**
     * Set autoOpenAlternatives value
     * @param bool $autoOpenAlternatives
     * @return \StructType\Article
     */
    public function setAutoOpenAlternatives($autoOpenAlternatives = null)
    {
        // validation for constraint: boolean
        if (!is_null($autoOpenAlternatives) && !is_bool($autoOpenAlternatives)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($autoOpenAlternatives, true), gettype($autoOpenAlternatives)), __LINE__);
        }
        $this->autoOpenAlternatives = $autoOpenAlternatives;
        return $this;
    }
    /**
     * Get confirmedDelivery value
     * @return bool|null
     */
    public function getConfirmedDelivery()
    {
        return $this->confirmedDelivery;
    }
    /**
     * Set confirmedDelivery value
     * @param bool $confirmedDelivery
     * @return \StructType\Article
     */
    public function setConfirmedDelivery($confirmedDelivery = null)
    {
        // validation for constraint: boolean
        if (!is_null($confirmedDelivery) && !is_bool($confirmedDelivery)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($confirmedDelivery, true), gettype($confirmedDelivery)), __LINE__);
        }
        $this->confirmedDelivery = $confirmedDelivery;
        return $this;
    }
    /**
     * Get costPrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getCostPrice()
    {
        return isset($this->costPrice) ? $this->costPrice : null;
    }
    /**
     * Set costPrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $costPrice
     * @return \StructType\Article
     */
    public function setCostPrice($costPrice = null)
    {
        // validation for constraint: float
        if (!is_null($costPrice) && !(is_float($costPrice) || is_numeric($costPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($costPrice, true), gettype($costPrice)), __LINE__);
        }
        if (is_null($costPrice) || (is_array($costPrice) && empty($costPrice))) {
            unset($this->costPrice);
        } else {
            $this->costPrice = $costPrice;
        }
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\Article
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get discount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getDiscount()
    {
        return isset($this->discount) ? $this->discount : null;
    }
    /**
     * Set discount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $discount
     * @return \StructType\Article
     */
    public function setDiscount($discount = null)
    {
        // validation for constraint: float
        if (!is_null($discount) && !(is_float($discount) || is_numeric($discount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($discount, true), gettype($discount)), __LINE__);
        }
        if (is_null($discount) || (is_array($discount) && empty($discount))) {
            unset($this->discount);
        } else {
            $this->discount = $discount;
        }
        return $this;
    }
    /**
     * Get discountFrom value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getDiscountFrom()
    {
        return isset($this->discountFrom) ? $this->discountFrom : null;
    }
    /**
     * Set discountFrom value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $discountFrom
     * @return \StructType\Article
     */
    public function setDiscountFrom($discountFrom = null)
    {
        // validation for constraint: int
        if (!is_null($discountFrom) && !(is_int($discountFrom) || ctype_digit($discountFrom))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($discountFrom, true), gettype($discountFrom)), __LINE__);
        }
        if (is_null($discountFrom) || (is_array($discountFrom) && empty($discountFrom))) {
            unset($this->discountFrom);
        } else {
            $this->discountFrom = $discountFrom;
        }
        return $this;
    }
    /**
     * Get discountTo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getDiscountTo()
    {
        return isset($this->discountTo) ? $this->discountTo : null;
    }
    /**
     * Set discountTo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $discountTo
     * @return \StructType\Article
     */
    public function setDiscountTo($discountTo = null)
    {
        // validation for constraint: int
        if (!is_null($discountTo) && !(is_int($discountTo) || ctype_digit($discountTo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($discountTo, true), gettype($discountTo)), __LINE__);
        }
        if (is_null($discountTo) || (is_array($discountTo) && empty($discountTo))) {
            unset($this->discountTo);
        } else {
            $this->discountTo = $discountTo;
        }
        return $this;
    }
    /**
     * Get eans value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getEans()
    {
        return isset($this->eans) ? $this->eans : null;
    }
    /**
     * This method is responsible for validating the values passed to the setEans method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEans method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEansForArrayConstraintsFromSetEans(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $articleEansItem) {
            // validation for constraint: itemType
            if (!is_string($articleEansItem)) {
                $invalidValues[] = is_object($articleEansItem) ? get_class($articleEansItem) : sprintf('%s(%s)', gettype($articleEansItem), var_export($articleEansItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The eans property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set eans value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param string[] $eans
     * @return \StructType\Article
     */
    public function setEans(array $eans = array())
    {
        // validation for constraint: array
        if ('' !== ($eansArrayErrorMessage = self::validateEansForArrayConstraintsFromSetEans($eans))) {
            throw new \InvalidArgumentException($eansArrayErrorMessage, __LINE__);
        }
        if (is_null($eans) || (is_array($eans) && empty($eans))) {
            unset($this->eans);
        } else {
            $this->eans = $eans;
        }
        return $this;
    }
    /**
     * Add item to eans value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\Article
     */
    public function addToEans($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The eans property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->eans[] = $item;
        return $this;
    }
    /**
     * Get expectedDeliveryAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getExpectedDeliveryAmount()
    {
        return isset($this->expectedDeliveryAmount) ? $this->expectedDeliveryAmount : null;
    }
    /**
     * Set expectedDeliveryAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $expectedDeliveryAmount
     * @return \StructType\Article
     */
    public function setExpectedDeliveryAmount($expectedDeliveryAmount = null)
    {
        // validation for constraint: int
        if (!is_null($expectedDeliveryAmount) && !(is_int($expectedDeliveryAmount) || ctype_digit($expectedDeliveryAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($expectedDeliveryAmount, true), gettype($expectedDeliveryAmount)), __LINE__);
        }
        if (is_null($expectedDeliveryAmount) || (is_array($expectedDeliveryAmount) && empty($expectedDeliveryAmount))) {
            unset($this->expectedDeliveryAmount);
        } else {
            $this->expectedDeliveryAmount = $expectedDeliveryAmount;
        }
        return $this;
    }
    /**
     * Get expectedDeliveryDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExpectedDeliveryDate()
    {
        return isset($this->expectedDeliveryDate) ? $this->expectedDeliveryDate : null;
    }
    /**
     * Set expectedDeliveryDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $expectedDeliveryDate
     * @return \StructType\Article
     */
    public function setExpectedDeliveryDate($expectedDeliveryDate = null)
    {
        // validation for constraint: string
        if (!is_null($expectedDeliveryDate) && !is_string($expectedDeliveryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expectedDeliveryDate, true), gettype($expectedDeliveryDate)), __LINE__);
        }
        if (is_null($expectedDeliveryDate) || (is_array($expectedDeliveryDate) && empty($expectedDeliveryDate))) {
            unset($this->expectedDeliveryDate);
        } else {
            $this->expectedDeliveryDate = $expectedDeliveryDate;
        }
        return $this;
    }
    /**
     * Get externalGroupId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getExternalGroupId()
    {
        return isset($this->externalGroupId) ? $this->externalGroupId : null;
    }
    /**
     * Set externalGroupId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $externalGroupId
     * @return \StructType\Article
     */
    public function setExternalGroupId($externalGroupId = null)
    {
        // validation for constraint: int
        if (!is_null($externalGroupId) && !(is_int($externalGroupId) || ctype_digit($externalGroupId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($externalGroupId, true), gettype($externalGroupId)), __LINE__);
        }
        if (is_null($externalGroupId) || (is_array($externalGroupId) && empty($externalGroupId))) {
            unset($this->externalGroupId);
        } else {
            $this->externalGroupId = $externalGroupId;
        }
        return $this;
    }
    /**
     * Get externalGroupId2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getExternalGroupId2()
    {
        return isset($this->externalGroupId2) ? $this->externalGroupId2 : null;
    }
    /**
     * Set externalGroupId2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $externalGroupId2
     * @return \StructType\Article
     */
    public function setExternalGroupId2($externalGroupId2 = null)
    {
        // validation for constraint: int
        if (!is_null($externalGroupId2) && !(is_int($externalGroupId2) || ctype_digit($externalGroupId2))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($externalGroupId2, true), gettype($externalGroupId2)), __LINE__);
        }
        if (is_null($externalGroupId2) || (is_array($externalGroupId2) && empty($externalGroupId2))) {
            unset($this->externalGroupId2);
        } else {
            $this->externalGroupId2 = $externalGroupId2;
        }
        return $this;
    }
    /**
     * Get externalLink value
     * @return string|null
     */
    public function getExternalLink()
    {
        return $this->externalLink;
    }
    /**
     * Set externalLink value
     * @param string $externalLink
     * @return \StructType\Article
     */
    public function setExternalLink($externalLink = null)
    {
        // validation for constraint: string
        if (!is_null($externalLink) && !is_string($externalLink)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalLink, true), gettype($externalLink)), __LINE__);
        }
        $this->externalLink = $externalLink;
        return $this;
    }
    /**
     * Get height value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getHeight()
    {
        return isset($this->height) ? $this->height : null;
    }
    /**
     * Set height value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $height
     * @return \StructType\Article
     */
    public function setHeight($height = null)
    {
        // validation for constraint: float
        if (!is_null($height) && !(is_float($height) || is_numeric($height))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($height, true), gettype($height)), __LINE__);
        }
        if (is_null($height) || (is_array($height) && empty($height))) {
            unset($this->height);
        } else {
            $this->height = $height;
        }
        return $this;
    }
    /**
     * Get hideWhenOutOfStock value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getHideWhenOutOfStock()
    {
        return isset($this->hideWhenOutOfStock) ? $this->hideWhenOutOfStock : null;
    }
    /**
     * Set hideWhenOutOfStock value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $hideWhenOutOfStock
     * @return \StructType\Article
     */
    public function setHideWhenOutOfStock($hideWhenOutOfStock = null)
    {
        // validation for constraint: boolean
        if (!is_null($hideWhenOutOfStock) && !is_bool($hideWhenOutOfStock)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hideWhenOutOfStock, true), gettype($hideWhenOutOfStock)), __LINE__);
        }
        if (is_null($hideWhenOutOfStock) || (is_array($hideWhenOutOfStock) && empty($hideWhenOutOfStock))) {
            unset($this->hideWhenOutOfStock);
        } else {
            $this->hideWhenOutOfStock = $hideWhenOutOfStock;
        }
        return $this;
    }
    /**
     * Get info1 value
     * @return string|null
     */
    public function getInfo1()
    {
        return $this->info1;
    }
    /**
     * Set info1 value
     * @param string $info1
     * @return \StructType\Article
     */
    public function setInfo1($info1 = null)
    {
        // validation for constraint: string
        if (!is_null($info1) && !is_string($info1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($info1, true), gettype($info1)), __LINE__);
        }
        $this->info1 = $info1;
        return $this;
    }
    /**
     * Get info2 value
     * @return string|null
     */
    public function getInfo2()
    {
        return $this->info2;
    }
    /**
     * Set info2 value
     * @param string $info2
     * @return \StructType\Article
     */
    public function setInfo2($info2 = null)
    {
        // validation for constraint: string
        if (!is_null($info2) && !is_string($info2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($info2, true), gettype($info2)), __LINE__);
        }
        $this->info2 = $info2;
        return $this;
    }
    /**
     * Get info3 value
     * @return string|null
     */
    public function getInfo3()
    {
        return $this->info3;
    }
    /**
     * Set info3 value
     * @param string $info3
     * @return \StructType\Article
     */
    public function setInfo3($info3 = null)
    {
        // validation for constraint: string
        if (!is_null($info3) && !is_string($info3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($info3, true), gettype($info3)), __LINE__);
        }
        $this->info3 = $info3;
        return $this;
    }
    /**
     * Get length value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getLength()
    {
        return isset($this->length) ? $this->length : null;
    }
    /**
     * Set length value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $length
     * @return \StructType\Article
     */
    public function setLength($length = null)
    {
        // validation for constraint: float
        if (!is_null($length) && !(is_float($length) || is_numeric($length))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($length, true), gettype($length)), __LINE__);
        }
        if (is_null($length) || (is_array($length) && empty($length))) {
            unset($this->length);
        } else {
            $this->length = $length;
        }
        return $this;
    }
    /**
     * Get manufacturer value
     * @return \StructType\Manufacturer|null
     */
    public function getManufacturer()
    {
        return $this->manufacturer;
    }
    /**
     * Set manufacturer value
     * @param \StructType\Manufacturer $manufacturer
     * @return \StructType\Article
     */
    public function setManufacturer(\StructType\Manufacturer $manufacturer = null)
    {
        $this->manufacturer = $manufacturer;
        return $this;
    }
    /**
     * Get manufacturerArticleNo value
     * @return string|null
     */
    public function getManufacturerArticleNo()
    {
        return $this->manufacturerArticleNo;
    }
    /**
     * Set manufacturerArticleNo value
     * @param string $manufacturerArticleNo
     * @return \StructType\Article
     */
    public function setManufacturerArticleNo($manufacturerArticleNo = null)
    {
        // validation for constraint: string
        if (!is_null($manufacturerArticleNo) && !is_string($manufacturerArticleNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($manufacturerArticleNo, true), gettype($manufacturerArticleNo)), __LINE__);
        }
        $this->manufacturerArticleNo = $manufacturerArticleNo;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\Article
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get noDiscount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getNoDiscount()
    {
        return isset($this->noDiscount) ? $this->noDiscount : null;
    }
    /**
     * Set noDiscount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $noDiscount
     * @return \StructType\Article
     */
    public function setNoDiscount($noDiscount = null)
    {
        // validation for constraint: boolean
        if (!is_null($noDiscount) && !is_bool($noDiscount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($noDiscount, true), gettype($noDiscount)), __LINE__);
        }
        if (is_null($noDiscount) || (is_array($noDiscount) && empty($noDiscount))) {
            unset($this->noDiscount);
        } else {
            $this->noDiscount = $noDiscount;
        }
        return $this;
    }
    /**
     * Get nonStockItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getNonStockItem()
    {
        return isset($this->nonStockItem) ? $this->nonStockItem : null;
    }
    /**
     * Set nonStockItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $nonStockItem
     * @return \StructType\Article
     */
    public function setNonStockItem($nonStockItem = null)
    {
        // validation for constraint: boolean
        if (!is_null($nonStockItem) && !is_bool($nonStockItem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($nonStockItem, true), gettype($nonStockItem)), __LINE__);
        }
        if (is_null($nonStockItem) || (is_array($nonStockItem) && empty($nonStockItem))) {
            unset($this->nonStockItem);
        } else {
            $this->nonStockItem = $nonStockItem;
        }
        return $this;
    }
    /**
     * Get nonStockItemDays value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNonStockItemDays()
    {
        return isset($this->nonStockItemDays) ? $this->nonStockItemDays : null;
    }
    /**
     * Set nonStockItemDays value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $nonStockItemDays
     * @return \StructType\Article
     */
    public function setNonStockItemDays($nonStockItemDays = null)
    {
        // validation for constraint: int
        if (!is_null($nonStockItemDays) && !(is_int($nonStockItemDays) || ctype_digit($nonStockItemDays))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($nonStockItemDays, true), gettype($nonStockItemDays)), __LINE__);
        }
        if (is_null($nonStockItemDays) || (is_array($nonStockItemDays) && empty($nonStockItemDays))) {
            unset($this->nonStockItemDays);
        } else {
            $this->nonStockItemDays = $nonStockItemDays;
        }
        return $this;
    }
    /**
     * Get price1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPrice1()
    {
        return isset($this->price1) ? $this->price1 : null;
    }
    /**
     * Set price1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $price1
     * @return \StructType\Article
     */
    public function setPrice1($price1 = null)
    {
        // validation for constraint: float
        if (!is_null($price1) && !(is_float($price1) || is_numeric($price1))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($price1, true), gettype($price1)), __LINE__);
        }
        if (is_null($price1) || (is_array($price1) && empty($price1))) {
            unset($this->price1);
        } else {
            $this->price1 = $price1;
        }
        return $this;
    }
    /**
     * Get price10 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPrice10()
    {
        return isset($this->price10) ? $this->price10 : null;
    }
    /**
     * Set price10 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $price10
     * @return \StructType\Article
     */
    public function setPrice10($price10 = null)
    {
        // validation for constraint: float
        if (!is_null($price10) && !(is_float($price10) || is_numeric($price10))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($price10, true), gettype($price10)), __LINE__);
        }
        if (is_null($price10) || (is_array($price10) && empty($price10))) {
            unset($this->price10);
        } else {
            $this->price10 = $price10;
        }
        return $this;
    }
    /**
     * Get price2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPrice2()
    {
        return isset($this->price2) ? $this->price2 : null;
    }
    /**
     * Set price2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $price2
     * @return \StructType\Article
     */
    public function setPrice2($price2 = null)
    {
        // validation for constraint: float
        if (!is_null($price2) && !(is_float($price2) || is_numeric($price2))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($price2, true), gettype($price2)), __LINE__);
        }
        if (is_null($price2) || (is_array($price2) && empty($price2))) {
            unset($this->price2);
        } else {
            $this->price2 = $price2;
        }
        return $this;
    }
    /**
     * Get price3 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPrice3()
    {
        return isset($this->price3) ? $this->price3 : null;
    }
    /**
     * Set price3 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $price3
     * @return \StructType\Article
     */
    public function setPrice3($price3 = null)
    {
        // validation for constraint: float
        if (!is_null($price3) && !(is_float($price3) || is_numeric($price3))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($price3, true), gettype($price3)), __LINE__);
        }
        if (is_null($price3) || (is_array($price3) && empty($price3))) {
            unset($this->price3);
        } else {
            $this->price3 = $price3;
        }
        return $this;
    }
    /**
     * Get price4 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPrice4()
    {
        return isset($this->price4) ? $this->price4 : null;
    }
    /**
     * Set price4 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $price4
     * @return \StructType\Article
     */
    public function setPrice4($price4 = null)
    {
        // validation for constraint: float
        if (!is_null($price4) && !(is_float($price4) || is_numeric($price4))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($price4, true), gettype($price4)), __LINE__);
        }
        if (is_null($price4) || (is_array($price4) && empty($price4))) {
            unset($this->price4);
        } else {
            $this->price4 = $price4;
        }
        return $this;
    }
    /**
     * Get price5 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPrice5()
    {
        return isset($this->price5) ? $this->price5 : null;
    }
    /**
     * Set price5 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $price5
     * @return \StructType\Article
     */
    public function setPrice5($price5 = null)
    {
        // validation for constraint: float
        if (!is_null($price5) && !(is_float($price5) || is_numeric($price5))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($price5, true), gettype($price5)), __LINE__);
        }
        if (is_null($price5) || (is_array($price5) && empty($price5))) {
            unset($this->price5);
        } else {
            $this->price5 = $price5;
        }
        return $this;
    }
    /**
     * Get price6 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPrice6()
    {
        return isset($this->price6) ? $this->price6 : null;
    }
    /**
     * Set price6 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $price6
     * @return \StructType\Article
     */
    public function setPrice6($price6 = null)
    {
        // validation for constraint: float
        if (!is_null($price6) && !(is_float($price6) || is_numeric($price6))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($price6, true), gettype($price6)), __LINE__);
        }
        if (is_null($price6) || (is_array($price6) && empty($price6))) {
            unset($this->price6);
        } else {
            $this->price6 = $price6;
        }
        return $this;
    }
    /**
     * Get price7 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPrice7()
    {
        return isset($this->price7) ? $this->price7 : null;
    }
    /**
     * Set price7 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $price7
     * @return \StructType\Article
     */
    public function setPrice7($price7 = null)
    {
        // validation for constraint: float
        if (!is_null($price7) && !(is_float($price7) || is_numeric($price7))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($price7, true), gettype($price7)), __LINE__);
        }
        if (is_null($price7) || (is_array($price7) && empty($price7))) {
            unset($this->price7);
        } else {
            $this->price7 = $price7;
        }
        return $this;
    }
    /**
     * Get price8 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPrice8()
    {
        return isset($this->price8) ? $this->price8 : null;
    }
    /**
     * Set price8 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $price8
     * @return \StructType\Article
     */
    public function setPrice8($price8 = null)
    {
        // validation for constraint: float
        if (!is_null($price8) && !(is_float($price8) || is_numeric($price8))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($price8, true), gettype($price8)), __LINE__);
        }
        if (is_null($price8) || (is_array($price8) && empty($price8))) {
            unset($this->price8);
        } else {
            $this->price8 = $price8;
        }
        return $this;
    }
    /**
     * Get price9 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPrice9()
    {
        return isset($this->price9) ? $this->price9 : null;
    }
    /**
     * Set price9 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $price9
     * @return \StructType\Article
     */
    public function setPrice9($price9 = null)
    {
        // validation for constraint: float
        if (!is_null($price9) && !(is_float($price9) || is_numeric($price9))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($price9, true), gettype($price9)), __LINE__);
        }
        if (is_null($price9) || (is_array($price9) && empty($price9))) {
            unset($this->price9);
        } else {
            $this->price9 = $price9;
        }
        return $this;
    }
    /**
     * Get productLine value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ProductLine|null
     */
    public function getProductLine()
    {
        return isset($this->productLine) ? $this->productLine : null;
    }
    /**
     * Set productLine value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ProductLine $productLine
     * @return \StructType\Article
     */
    public function setProductLine(\StructType\ProductLine $productLine = null)
    {
        if (is_null($productLine) || (is_array($productLine) && empty($productLine))) {
            unset($this->productLine);
        } else {
            $this->productLine = $productLine;
        }
        return $this;
    }
    /**
     * Get purchasePrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPurchasePrice()
    {
        return isset($this->purchasePrice) ? $this->purchasePrice : null;
    }
    /**
     * Set purchasePrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $purchasePrice
     * @return \StructType\Article
     */
    public function setPurchasePrice($purchasePrice = null)
    {
        // validation for constraint: float
        if (!is_null($purchasePrice) && !(is_float($purchasePrice) || is_numeric($purchasePrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($purchasePrice, true), gettype($purchasePrice)), __LINE__);
        }
        if (is_null($purchasePrice) || (is_array($purchasePrice) && empty($purchasePrice))) {
            unset($this->purchasePrice);
        } else {
            $this->purchasePrice = $purchasePrice;
        }
        return $this;
    }
    /**
     * Get recommendedProduct value
     * @return bool|null
     */
    public function getRecommendedProduct()
    {
        return $this->recommendedProduct;
    }
    /**
     * Set recommendedProduct value
     * @param bool $recommendedProduct
     * @return \StructType\Article
     */
    public function setRecommendedProduct($recommendedProduct = null)
    {
        // validation for constraint: boolean
        if (!is_null($recommendedProduct) && !is_bool($recommendedProduct)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($recommendedProduct, true), gettype($recommendedProduct)), __LINE__);
        }
        $this->recommendedProduct = $recommendedProduct;
        return $this;
    }
    /**
     * Get salesPrice value
     * @return float|null
     */
    public function getSalesPrice()
    {
        return $this->salesPrice;
    }
    /**
     * Set salesPrice value
     * @param float $salesPrice
     * @return \StructType\Article
     */
    public function setSalesPrice($salesPrice = null)
    {
        // validation for constraint: float
        if (!is_null($salesPrice) && !(is_float($salesPrice) || is_numeric($salesPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($salesPrice, true), gettype($salesPrice)), __LINE__);
        }
        $this->salesPrice = $salesPrice;
        return $this;
    }
    /**
     * Get shippingType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getShippingType()
    {
        return isset($this->shippingType) ? $this->shippingType : null;
    }
    /**
     * Set shippingType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $shippingType
     * @return \StructType\Article
     */
    public function setShippingType($shippingType = null)
    {
        // validation for constraint: int
        if (!is_null($shippingType) && !(is_int($shippingType) || ctype_digit($shippingType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($shippingType, true), gettype($shippingType)), __LINE__);
        }
        if (is_null($shippingType) || (is_array($shippingType) && empty($shippingType))) {
            unset($this->shippingType);
        } else {
            $this->shippingType = $shippingType;
        }
        return $this;
    }
    /**
     * Get sizeColorInUse value
     * @return bool|null
     */
    public function getSizeColorInUse()
    {
        return $this->sizeColorInUse;
    }
    /**
     * Set sizeColorInUse value
     * @param bool $sizeColorInUse
     * @return \StructType\Article
     */
    public function setSizeColorInUse($sizeColorInUse = null)
    {
        // validation for constraint: boolean
        if (!is_null($sizeColorInUse) && !is_bool($sizeColorInUse)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($sizeColorInUse, true), gettype($sizeColorInUse)), __LINE__);
        }
        $this->sizeColorInUse = $sizeColorInUse;
        return $this;
    }
    /**
     * Get sizeColors value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\SizeColor[]|null
     */
    public function getSizeColors()
    {
        return isset($this->sizeColors) ? $this->sizeColors : null;
    }
    /**
     * This method is responsible for validating the values passed to the setSizeColors method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSizeColors method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSizeColorsForArrayConstraintsFromSetSizeColors(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $articleSizeColorsItem) {
            // validation for constraint: itemType
            if (!$articleSizeColorsItem instanceof \StructType\SizeColor) {
                $invalidValues[] = is_object($articleSizeColorsItem) ? get_class($articleSizeColorsItem) : sprintf('%s(%s)', gettype($articleSizeColorsItem), var_export($articleSizeColorsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The sizeColors property can only contain items of type \StructType\SizeColor, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set sizeColors value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\SizeColor[] $sizeColors
     * @return \StructType\Article
     */
    public function setSizeColors(array $sizeColors = array())
    {
        // validation for constraint: array
        if ('' !== ($sizeColorsArrayErrorMessage = self::validateSizeColorsForArrayConstraintsFromSetSizeColors($sizeColors))) {
            throw new \InvalidArgumentException($sizeColorsArrayErrorMessage, __LINE__);
        }
        if (is_null($sizeColors) || (is_array($sizeColors) && empty($sizeColors))) {
            unset($this->sizeColors);
        } else {
            $this->sizeColors = $sizeColors;
        }
        return $this;
    }
    /**
     * Add item to sizeColors value
     * @throws \InvalidArgumentException
     * @param \StructType\SizeColor $item
     * @return \StructType\Article
     */
    public function addToSizeColors(\StructType\SizeColor $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SizeColor) {
            throw new \InvalidArgumentException(sprintf('The sizeColors property can only contain items of type \StructType\SizeColor, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->sizeColors[] = $item;
        return $this;
    }
    /**
     * Get stockCcount value
     * @return int|null
     */
    public function getStockCcount()
    {
        return $this->stockCcount;
    }
    /**
     * Set stockCcount value
     * @param int $stockCcount
     * @return \StructType\Article
     */
    public function setStockCcount($stockCcount = null)
    {
        // validation for constraint: int
        if (!is_null($stockCcount) && !(is_int($stockCcount) || ctype_digit($stockCcount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($stockCcount, true), gettype($stockCcount)), __LINE__);
        }
        $this->stockCcount = $stockCcount;
        return $this;
    }
    /**
     * Get stockCount value
     * @return int|null
     */
    public function getStockCount()
    {
        return $this->stockCount;
    }
    /**
     * Set stockCount value
     * @param int $stockCount
     * @return \StructType\Article
     */
    public function setStockCount($stockCount = null)
    {
        // validation for constraint: int
        if (!is_null($stockCount) && !(is_int($stockCount) || ctype_digit($stockCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($stockCount, true), gettype($stockCount)), __LINE__);
        }
        $this->stockCount = $stockCount;
        return $this;
    }
    /**
     * Get stockDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StockDetail[]|null
     */
    public function getStockDetails()
    {
        return isset($this->stockDetails) ? $this->stockDetails : null;
    }
    /**
     * This method is responsible for validating the values passed to the setStockDetails method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStockDetails method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStockDetailsForArrayConstraintsFromSetStockDetails(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $articleStockDetailsItem) {
            // validation for constraint: itemType
            if (!$articleStockDetailsItem instanceof \StructType\StockDetail) {
                $invalidValues[] = is_object($articleStockDetailsItem) ? get_class($articleStockDetailsItem) : sprintf('%s(%s)', gettype($articleStockDetailsItem), var_export($articleStockDetailsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The stockDetails property can only contain items of type \StructType\StockDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set stockDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\StockDetail[] $stockDetails
     * @return \StructType\Article
     */
    public function setStockDetails(array $stockDetails = array())
    {
        // validation for constraint: array
        if ('' !== ($stockDetailsArrayErrorMessage = self::validateStockDetailsForArrayConstraintsFromSetStockDetails($stockDetails))) {
            throw new \InvalidArgumentException($stockDetailsArrayErrorMessage, __LINE__);
        }
        if (is_null($stockDetails) || (is_array($stockDetails) && empty($stockDetails))) {
            unset($this->stockDetails);
        } else {
            $this->stockDetails = $stockDetails;
        }
        return $this;
    }
    /**
     * Add item to stockDetails value
     * @throws \InvalidArgumentException
     * @param \StructType\StockDetail $item
     * @return \StructType\Article
     */
    public function addToStockDetails(\StructType\StockDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\StockDetail) {
            throw new \InvalidArgumentException(sprintf('The stockDetails property can only contain items of type \StructType\StockDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->stockDetails[] = $item;
        return $this;
    }
    /**
     * Get storePrice value
     * @return float|null
     */
    public function getStorePrice()
    {
        return $this->storePrice;
    }
    /**
     * Set storePrice value
     * @param float $storePrice
     * @return \StructType\Article
     */
    public function setStorePrice($storePrice = null)
    {
        // validation for constraint: float
        if (!is_null($storePrice) && !(is_float($storePrice) || is_numeric($storePrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($storePrice, true), gettype($storePrice)), __LINE__);
        }
        $this->storePrice = $storePrice;
        return $this;
    }
    /**
     * Get subtitle value
     * @return string|null
     */
    public function getSubtitle()
    {
        return $this->subtitle;
    }
    /**
     * Set subtitle value
     * @param string $subtitle
     * @return \StructType\Article
     */
    public function setSubtitle($subtitle = null)
    {
        // validation for constraint: string
        if (!is_null($subtitle) && !is_string($subtitle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subtitle, true), gettype($subtitle)), __LINE__);
        }
        $this->subtitle = $subtitle;
        return $this;
    }
    /**
     * Get suggestedPrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getSuggestedPrice()
    {
        return isset($this->suggestedPrice) ? $this->suggestedPrice : null;
    }
    /**
     * Set suggestedPrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $suggestedPrice
     * @return \StructType\Article
     */
    public function setSuggestedPrice($suggestedPrice = null)
    {
        // validation for constraint: float
        if (!is_null($suggestedPrice) && !(is_float($suggestedPrice) || is_numeric($suggestedPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($suggestedPrice, true), gettype($suggestedPrice)), __LINE__);
        }
        if (is_null($suggestedPrice) || (is_array($suggestedPrice) && empty($suggestedPrice))) {
            unset($this->suggestedPrice);
        } else {
            $this->suggestedPrice = $suggestedPrice;
        }
        return $this;
    }
    /**
     * Get timestamp value
     * @return int|null
     */
    public function getTimestamp()
    {
        return $this->timestamp;
    }
    /**
     * Set timestamp value
     * @param int $timestamp
     * @return \StructType\Article
     */
    public function setTimestamp($timestamp = null)
    {
        // validation for constraint: int
        if (!is_null($timestamp) && !(is_int($timestamp) || ctype_digit($timestamp))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($timestamp, true), gettype($timestamp)), __LINE__);
        }
        $this->timestamp = $timestamp;
        return $this;
    }
    /**
     * Get vat value
     * @return float|null
     */
    public function getVat()
    {
        return $this->vat;
    }
    /**
     * Set vat value
     * @param float $vat
     * @return \StructType\Article
     */
    public function setVat($vat = null)
    {
        // validation for constraint: float
        if (!is_null($vat) && !(is_float($vat) || is_numeric($vat))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($vat, true), gettype($vat)), __LINE__);
        }
        $this->vat = $vat;
        return $this;
    }
    /**
     * Get visibleOnWeb value
     * @return bool|null
     */
    public function getVisibleOnWeb()
    {
        return $this->visibleOnWeb;
    }
    /**
     * Set visibleOnWeb value
     * @param bool $visibleOnWeb
     * @return \StructType\Article
     */
    public function setVisibleOnWeb($visibleOnWeb = null)
    {
        // validation for constraint: boolean
        if (!is_null($visibleOnWeb) && !is_bool($visibleOnWeb)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($visibleOnWeb, true), gettype($visibleOnWeb)), __LINE__);
        }
        $this->visibleOnWeb = $visibleOnWeb;
        return $this;
    }
    /**
     * Get volume value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getVolume()
    {
        return isset($this->volume) ? $this->volume : null;
    }
    /**
     * Set volume value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $volume
     * @return \StructType\Article
     */
    public function setVolume($volume = null)
    {
        // validation for constraint: float
        if (!is_null($volume) && !(is_float($volume) || is_numeric($volume))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($volume, true), gettype($volume)), __LINE__);
        }
        if (is_null($volume) || (is_array($volume) && empty($volume))) {
            unset($this->volume);
        } else {
            $this->volume = $volume;
        }
        return $this;
    }
    /**
     * Get webshippingPrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getWebshippingPrice()
    {
        return isset($this->webshippingPrice) ? $this->webshippingPrice : null;
    }
    /**
     * Set webshippingPrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $webshippingPrice
     * @return \StructType\Article
     */
    public function setWebshippingPrice($webshippingPrice = null)
    {
        // validation for constraint: float
        if (!is_null($webshippingPrice) && !(is_float($webshippingPrice) || is_numeric($webshippingPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($webshippingPrice, true), gettype($webshippingPrice)), __LINE__);
        }
        if (is_null($webshippingPrice) || (is_array($webshippingPrice) && empty($webshippingPrice))) {
            unset($this->webshippingPrice);
        } else {
            $this->webshippingPrice = $webshippingPrice;
        }
        return $this;
    }
    /**
     * Get webstockLimit value
     * @return int|null
     */
    public function getWebstockLimit()
    {
        return $this->webstockLimit;
    }
    /**
     * Set webstockLimit value
     * @param int $webstockLimit
     * @return \StructType\Article
     */
    public function setWebstockLimit($webstockLimit = null)
    {
        // validation for constraint: int
        if (!is_null($webstockLimit) && !(is_int($webstockLimit) || ctype_digit($webstockLimit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($webstockLimit, true), gettype($webstockLimit)), __LINE__);
        }
        $this->webstockLimit = $webstockLimit;
        return $this;
    }
    /**
     * Get weight value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getWeight()
    {
        return isset($this->weight) ? $this->weight : null;
    }
    /**
     * Set weight value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $weight
     * @return \StructType\Article
     */
    public function setWeight($weight = null)
    {
        // validation for constraint: float
        if (!is_null($weight) && !(is_float($weight) || is_numeric($weight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($weight, true), gettype($weight)), __LINE__);
        }
        if (is_null($weight) || (is_array($weight) && empty($weight))) {
            unset($this->weight);
        } else {
            $this->weight = $weight;
        }
        return $this;
    }
    /**
     * Get width value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getWidth()
    {
        return isset($this->width) ? $this->width : null;
    }
    /**
     * Set width value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $width
     * @return \StructType\Article
     */
    public function setWidth($width = null)
    {
        // validation for constraint: float
        if (!is_null($width) && !(is_float($width) || is_numeric($width))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($width, true), gettype($width)), __LINE__);
        }
        if (is_null($width) || (is_array($width) && empty($width))) {
            unset($this->width);
        } else {
            $this->width = $width;
        }
        return $this;
    }
}
