<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Greet ServiceType
 * @subpackage Services
 */
class Greet extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named greet
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Greet $parameters
     * @return \StructType\GreetResponse|bool
     */
    public function greet(\StructType\Greet $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->greet($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GreetResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
