<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for updateStock StructType
 * @subpackage Structs
 */
class UpdateStock extends AbstractStructBase
{
    /**
     * The articleId
     * @var int
     */
    public $articleId;
    /**
     * The confirmedDelivery
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var bool
     */
    public $confirmedDelivery;
    /**
     * The count
     * @var int
     */
    public $count;
    /**
     * The expectedDeliveryAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $expectedDeliveryAmount;
    /**
     * The expectedDeliveryDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $expectedDeliveryDate;
    /**
     * The sizeColorId
     * @var int
     */
    public $sizeColorId;
    /**
     * The stockDetails
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StockDetail[]
     */
    public $stockDetails;
    /**
     * The timestamp
     * @var int
     */
    public $timestamp;
    /**
     * Constructor method for updateStock
     * @uses UpdateStock::setArticleId()
     * @uses UpdateStock::setConfirmedDelivery()
     * @uses UpdateStock::setCount()
     * @uses UpdateStock::setExpectedDeliveryAmount()
     * @uses UpdateStock::setExpectedDeliveryDate()
     * @uses UpdateStock::setSizeColorId()
     * @uses UpdateStock::setStockDetails()
     * @uses UpdateStock::setTimestamp()
     * @param int $articleId
     * @param bool $confirmedDelivery
     * @param int $count
     * @param int $expectedDeliveryAmount
     * @param string $expectedDeliveryDate
     * @param int $sizeColorId
     * @param \StructType\StockDetail[] $stockDetails
     * @param int $timestamp
     */
    public function __construct($articleId = null, $confirmedDelivery = null, $count = null, $expectedDeliveryAmount = null, $expectedDeliveryDate = null, $sizeColorId = null, array $stockDetails = array(), $timestamp = null)
    {
        $this
            ->setArticleId($articleId)
            ->setConfirmedDelivery($confirmedDelivery)
            ->setCount($count)
            ->setExpectedDeliveryAmount($expectedDeliveryAmount)
            ->setExpectedDeliveryDate($expectedDeliveryDate)
            ->setSizeColorId($sizeColorId)
            ->setStockDetails($stockDetails)
            ->setTimestamp($timestamp);
    }
    /**
     * Get articleId value
     * @return int|null
     */
    public function getArticleId()
    {
        return $this->articleId;
    }
    /**
     * Set articleId value
     * @param int $articleId
     * @return \StructType\UpdateStock
     */
    public function setArticleId($articleId = null)
    {
        // validation for constraint: int
        if (!is_null($articleId) && !(is_int($articleId) || ctype_digit($articleId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($articleId, true), gettype($articleId)), __LINE__);
        }
        $this->articleId = $articleId;
        return $this;
    }
    /**
     * Get confirmedDelivery value
     * @return bool|null
     */
    public function getConfirmedDelivery()
    {
        return $this->confirmedDelivery;
    }
    /**
     * Set confirmedDelivery value
     * @param bool $confirmedDelivery
     * @return \StructType\UpdateStock
     */
    public function setConfirmedDelivery($confirmedDelivery = null)
    {
        // validation for constraint: boolean
        if (!is_null($confirmedDelivery) && !is_bool($confirmedDelivery)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($confirmedDelivery, true), gettype($confirmedDelivery)), __LINE__);
        }
        $this->confirmedDelivery = $confirmedDelivery;
        return $this;
    }
    /**
     * Get count value
     * @return int|null
     */
    public function getCount()
    {
        return $this->count;
    }
    /**
     * Set count value
     * @param int $count
     * @return \StructType\UpdateStock
     */
    public function setCount($count = null)
    {
        // validation for constraint: int
        if (!is_null($count) && !(is_int($count) || ctype_digit($count))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($count, true), gettype($count)), __LINE__);
        }
        $this->count = $count;
        return $this;
    }
    /**
     * Get expectedDeliveryAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getExpectedDeliveryAmount()
    {
        return isset($this->expectedDeliveryAmount) ? $this->expectedDeliveryAmount : null;
    }
    /**
     * Set expectedDeliveryAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $expectedDeliveryAmount
     * @return \StructType\UpdateStock
     */
    public function setExpectedDeliveryAmount($expectedDeliveryAmount = null)
    {
        // validation for constraint: int
        if (!is_null($expectedDeliveryAmount) && !(is_int($expectedDeliveryAmount) || ctype_digit($expectedDeliveryAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($expectedDeliveryAmount, true), gettype($expectedDeliveryAmount)), __LINE__);
        }
        if (is_null($expectedDeliveryAmount) || (is_array($expectedDeliveryAmount) && empty($expectedDeliveryAmount))) {
            unset($this->expectedDeliveryAmount);
        } else {
            $this->expectedDeliveryAmount = $expectedDeliveryAmount;
        }
        return $this;
    }
    /**
     * Get expectedDeliveryDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExpectedDeliveryDate()
    {
        return isset($this->expectedDeliveryDate) ? $this->expectedDeliveryDate : null;
    }
    /**
     * Set expectedDeliveryDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $expectedDeliveryDate
     * @return \StructType\UpdateStock
     */
    public function setExpectedDeliveryDate($expectedDeliveryDate = null)
    {
        // validation for constraint: string
        if (!is_null($expectedDeliveryDate) && !is_string($expectedDeliveryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expectedDeliveryDate, true), gettype($expectedDeliveryDate)), __LINE__);
        }
        if (is_null($expectedDeliveryDate) || (is_array($expectedDeliveryDate) && empty($expectedDeliveryDate))) {
            unset($this->expectedDeliveryDate);
        } else {
            $this->expectedDeliveryDate = $expectedDeliveryDate;
        }
        return $this;
    }
    /**
     * Get sizeColorId value
     * @return int|null
     */
    public function getSizeColorId()
    {
        return $this->sizeColorId;
    }
    /**
     * Set sizeColorId value
     * @param int $sizeColorId
     * @return \StructType\UpdateStock
     */
    public function setSizeColorId($sizeColorId = null)
    {
        // validation for constraint: int
        if (!is_null($sizeColorId) && !(is_int($sizeColorId) || ctype_digit($sizeColorId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sizeColorId, true), gettype($sizeColorId)), __LINE__);
        }
        $this->sizeColorId = $sizeColorId;
        return $this;
    }
    /**
     * Get stockDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StockDetail[]|null
     */
    public function getStockDetails()
    {
        return isset($this->stockDetails) ? $this->stockDetails : null;
    }
    /**
     * This method is responsible for validating the values passed to the setStockDetails method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStockDetails method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStockDetailsForArrayConstraintsFromSetStockDetails(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $updateStockStockDetailsItem) {
            // validation for constraint: itemType
            if (!$updateStockStockDetailsItem instanceof \StructType\StockDetail) {
                $invalidValues[] = is_object($updateStockStockDetailsItem) ? get_class($updateStockStockDetailsItem) : sprintf('%s(%s)', gettype($updateStockStockDetailsItem), var_export($updateStockStockDetailsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The stockDetails property can only contain items of type \StructType\StockDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set stockDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\StockDetail[] $stockDetails
     * @return \StructType\UpdateStock
     */
    public function setStockDetails(array $stockDetails = array())
    {
        // validation for constraint: array
        if ('' !== ($stockDetailsArrayErrorMessage = self::validateStockDetailsForArrayConstraintsFromSetStockDetails($stockDetails))) {
            throw new \InvalidArgumentException($stockDetailsArrayErrorMessage, __LINE__);
        }
        if (is_null($stockDetails) || (is_array($stockDetails) && empty($stockDetails))) {
            unset($this->stockDetails);
        } else {
            $this->stockDetails = $stockDetails;
        }
        return $this;
    }
    /**
     * Add item to stockDetails value
     * @throws \InvalidArgumentException
     * @param \StructType\StockDetail $item
     * @return \StructType\UpdateStock
     */
    public function addToStockDetails(\StructType\StockDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\StockDetail) {
            throw new \InvalidArgumentException(sprintf('The stockDetails property can only contain items of type \StructType\StockDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->stockDetails[] = $item;
        return $this;
    }
    /**
     * Get timestamp value
     * @return int|null
     */
    public function getTimestamp()
    {
        return $this->timestamp;
    }
    /**
     * Set timestamp value
     * @param int $timestamp
     * @return \StructType\UpdateStock
     */
    public function setTimestamp($timestamp = null)
    {
        // validation for constraint: int
        if (!is_null($timestamp) && !(is_int($timestamp) || ctype_digit($timestamp))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($timestamp, true), gettype($timestamp)), __LINE__);
        }
        $this->timestamp = $timestamp;
        return $this;
    }
}
