<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for sendArticle StructType
 * Meta information extracted from the WSDL
 * - type: tns:sendArticle
 * @subpackage Structs
 */
class SendArticle extends AbstractStructBase
{
    /**
     * The login
     * @var int
     */
    public $login;
    /**
     * The password
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $password;
    /**
     * The article
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Article
     */
    public $article;
    /**
     * Constructor method for sendArticle
     * @uses SendArticle::setLogin()
     * @uses SendArticle::setPassword()
     * @uses SendArticle::setArticle()
     * @param int $login
     * @param string $password
     * @param \StructType\Article $article
     */
    public function __construct($login = null, $password = null, \StructType\Article $article = null)
    {
        $this
            ->setLogin($login)
            ->setPassword($password)
            ->setArticle($article);
    }
    /**
     * Get login value
     * @return int|null
     */
    public function getLogin()
    {
        return $this->login;
    }
    /**
     * Set login value
     * @param int $login
     * @return \StructType\SendArticle
     */
    public function setLogin($login = null)
    {
        // validation for constraint: int
        if (!is_null($login) && !(is_int($login) || ctype_digit($login))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($login, true), gettype($login)), __LINE__);
        }
        $this->login = $login;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \StructType\SendArticle
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get article value
     * @return \StructType\Article|null
     */
    public function getArticle()
    {
        return $this->article;
    }
    /**
     * Set article value
     * @param \StructType\Article $article
     * @return \StructType\SendArticle
     */
    public function setArticle(\StructType\Article $article = null)
    {
        $this->article = $article;
        return $this;
    }
}
