<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for manufacturer StructType
 * @subpackage Structs
 */
class Manufacturer extends AbstractStructBase
{
    /**
     * The manufacturerId
     * @var int
     */
    public $manufacturerId;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The timestamp
     * @var int
     */
    public $timestamp;
    /**
     * Constructor method for manufacturer
     * @uses Manufacturer::setManufacturerId()
     * @uses Manufacturer::setName()
     * @uses Manufacturer::setTimestamp()
     * @param int $manufacturerId
     * @param string $name
     * @param int $timestamp
     */
    public function __construct($manufacturerId = null, $name = null, $timestamp = null)
    {
        $this
            ->setManufacturerId($manufacturerId)
            ->setName($name)
            ->setTimestamp($timestamp);
    }
    /**
     * Get manufacturerId value
     * @return int|null
     */
    public function getManufacturerId()
    {
        return $this->manufacturerId;
    }
    /**
     * Set manufacturerId value
     * @param int $manufacturerId
     * @return \StructType\Manufacturer
     */
    public function setManufacturerId($manufacturerId = null)
    {
        // validation for constraint: int
        if (!is_null($manufacturerId) && !(is_int($manufacturerId) || ctype_digit($manufacturerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($manufacturerId, true), gettype($manufacturerId)), __LINE__);
        }
        $this->manufacturerId = $manufacturerId;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\Manufacturer
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get timestamp value
     * @return int|null
     */
    public function getTimestamp()
    {
        return $this->timestamp;
    }
    /**
     * Set timestamp value
     * @param int $timestamp
     * @return \StructType\Manufacturer
     */
    public function setTimestamp($timestamp = null)
    {
        // validation for constraint: int
        if (!is_null($timestamp) && !(is_int($timestamp) || ctype_digit($timestamp))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($timestamp, true), gettype($timestamp)), __LINE__);
        }
        $this->timestamp = $timestamp;
        return $this;
    }
}
