<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getOrders StructType
 * Meta information extracted from the WSDL
 * - type: tns:getOrders
 * @subpackage Structs
 */
class GetOrders extends AbstractStructBase
{
    /**
     * The login
     * @var int
     */
    public $login;
    /**
     * The password
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $password;
    /**
     * The computerName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $computerName;
    /**
     * Constructor method for getOrders
     * @uses GetOrders::setLogin()
     * @uses GetOrders::setPassword()
     * @uses GetOrders::setComputerName()
     * @param int $login
     * @param string $password
     * @param string $computerName
     */
    public function __construct($login = null, $password = null, $computerName = null)
    {
        $this
            ->setLogin($login)
            ->setPassword($password)
            ->setComputerName($computerName);
    }
    /**
     * Get login value
     * @return int|null
     */
    public function getLogin()
    {
        return $this->login;
    }
    /**
     * Set login value
     * @param int $login
     * @return \StructType\GetOrders
     */
    public function setLogin($login = null)
    {
        // validation for constraint: int
        if (!is_null($login) && !(is_int($login) || ctype_digit($login))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($login, true), gettype($login)), __LINE__);
        }
        $this->login = $login;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \StructType\GetOrders
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get computerName value
     * @return string|null
     */
    public function getComputerName()
    {
        return $this->computerName;
    }
    /**
     * Set computerName value
     * @param string $computerName
     * @return \StructType\GetOrders
     */
    public function setComputerName($computerName = null)
    {
        // validation for constraint: string
        if (!is_null($computerName) && !is_string($computerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($computerName, true), gettype($computerName)), __LINE__);
        }
        $this->computerName = $computerName;
        return $this;
    }
}
