<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for customerGroup StructType
 * @subpackage Structs
 */
class CustomerGroup extends AbstractStructBase
{
    /**
     * The customerGroupId
     * @var int
     */
    public $customerGroupId;
    /**
     * The name
     * @var string
     */
    public $name;
    /**
     * Constructor method for customerGroup
     * @uses CustomerGroup::setCustomerGroupId()
     * @uses CustomerGroup::setName()
     * @param int $customerGroupId
     * @param string $name
     */
    public function __construct($customerGroupId = null, $name = null)
    {
        $this
            ->setCustomerGroupId($customerGroupId)
            ->setName($name);
    }
    /**
     * Get customerGroupId value
     * @return int|null
     */
    public function getCustomerGroupId()
    {
        return $this->customerGroupId;
    }
    /**
     * Set customerGroupId value
     * @param int $customerGroupId
     * @return \StructType\CustomerGroup
     */
    public function setCustomerGroupId($customerGroupId = null)
    {
        // validation for constraint: int
        if (!is_null($customerGroupId) && !(is_int($customerGroupId) || ctype_digit($customerGroupId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerGroupId, true), gettype($customerGroupId)), __LINE__);
        }
        $this->customerGroupId = $customerGroupId;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\CustomerGroup
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
}
