<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for alternative StructType
 * @subpackage Structs
 */
class Alternative extends AbstractStructBase
{
    /**
     * The amountChange
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $amountChange;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * Constructor method for alternative
     * @uses Alternative::setAmountChange()
     * @uses Alternative::setDescription()
     * @param float $amountChange
     * @param string $description
     */
    public function __construct($amountChange = null, $description = null)
    {
        $this
            ->setAmountChange($amountChange)
            ->setDescription($description);
    }
    /**
     * Get amountChange value
     * @return float|null
     */
    public function getAmountChange()
    {
        return $this->amountChange;
    }
    /**
     * Set amountChange value
     * @param float $amountChange
     * @return \StructType\Alternative
     */
    public function setAmountChange($amountChange = null)
    {
        // validation for constraint: float
        if (!is_null($amountChange) && !(is_float($amountChange) || is_numeric($amountChange))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amountChange, true), gettype($amountChange)), __LINE__);
        }
        $this->amountChange = $amountChange;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\Alternative
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
}
