<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Send ServiceType
 * @subpackage Services
 */
class Send extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named sendImageColor
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SendImageColor $parameters
     * @return \StructType\SendImageColorResponse|bool
     */
    public function sendImageColor(\StructType\SendImageColor $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->sendImageColor($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named sendColor
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SendColor $parameters
     * @return \StructType\SendColorResponse|bool
     */
    public function sendColor(\StructType\SendColor $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->sendColor($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named sendSize
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SendSize $parameters
     * @return \StructType\SendSizeResponse|bool
     */
    public function sendSize(\StructType\SendSize $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->sendSize($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named sendImage
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SendImage $parameters
     * @return \StructType\SendImageResponse|bool
     */
    public function sendImage(\StructType\SendImage $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->sendImage($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named sendArticle
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SendArticle $parameters
     * @return \StructType\SendArticleResponse|bool
     */
    public function sendArticle(\StructType\SendArticle $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->sendArticle($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named sendDiscount
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SendDiscount $parameters
     * @return \StructType\SendDiscountResponse|bool
     */
    public function sendDiscount(\StructType\SendDiscount $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->sendDiscount($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named sendArticleGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SendArticleGroup $parameters
     * @return \StructType\SendArticleGroupResponse|bool
     */
    public function sendArticleGroup(\StructType\SendArticleGroup $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->sendArticleGroup($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named sendProductLine
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SendProductLine $parameters
     * @return \StructType\SendProductLineResponse|bool
     */
    public function sendProductLine(\StructType\SendProductLine $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->sendProductLine($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named sendCustomerGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SendCustomerGroup $parameters
     * @return \StructType\SendCustomerGroupResponse|bool
     */
    public function sendCustomerGroup(\StructType\SendCustomerGroup $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->sendCustomerGroup($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named sendCustomerInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SendCustomerInfo $parameters
     * @return \StructType\SendCustomerInfoResponse|bool
     */
    public function sendCustomerInfo(\StructType\SendCustomerInfo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->sendCustomerInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named sendSizeColor
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SendSizeColor $parameters
     * @return \StructType\SendSizeColorResponse|bool
     */
    public function sendSizeColor(\StructType\SendSizeColor $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->sendSizeColor($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named sendManufacturer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SendManufacturer $parameters
     * @return \StructType\SendManufacturerResponse|bool
     */
    public function sendManufacturer(\StructType\SendManufacturer $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->sendManufacturer($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\SendArticleGroupResponse|\StructType\SendArticleResponse|\StructType\SendColorResponse|\StructType\SendCustomerGroupResponse|\StructType\SendCustomerInfoResponse|\StructType\SendDiscountResponse|\StructType\SendImageColorResponse|\StructType\SendImageResponse|\StructType\SendManufacturerResponse|\StructType\SendProductLineResponse|\StructType\SendSizeColorResponse|\StructType\SendSizeResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
