<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named getVesselSummary
     * Meta information extracted from the WSDL
     * - documentation: Returns:<ul><li>VesselID(Integer): Vessel Identification Number<li>VesselName(String): Vessel Name<li>Identification(String): Primary Vessel Identification Number<li>HIN(String): Hull Identification Number<li>VesselCallSign(String):
     * Vessel Call Sign<li>StatusLookupName(String): Vessel Status<li>OutOfServiceDate(DateTime): Out of Service Date - If Applicable<li>ServiceType(String): Vessel Service<li>CountryLookupName(String): Vessel Flag<li>ConstructionCompletedYear(Integer):
     * Year Vessel Was Built</ul><br/><br/><i>The following strings may be used for Vessel Service type searches:</i><br/>- Commercial Fishing Vessel<br/>- Fish Processing Vessel<br/>- Freight Barge<br/>- Freight Ship<br/>- Industrial Vessel<br/>- Mobile
     * Offshore Drilling Unit<br/>- Offshore Supply Vessel<br/>- Oil Recovery<br/>- Passenger (Inspected)<br/>- Passenger (Uninspected)<br/>- Passenger Barge (Inspected)<br/>- Passenger Barge (Uninspected)<br/>- Public Freight<br/>- Public
     * Tankship/Barge<br/>- Public Vessel, Unclassified<br/>- Recreational<br/>- Research Vessel<br/>- School Ship<br/>- Tank Barge<br/>- Tank Ship<br/>- Towing Vessel<br/>- Unclassified<br/>- Unknown<br/>- ALL<br/><br/><i>This procedure also accepts wild
     * cards for Vessel Service. A search for 'Barge' will return all barges (i.e. Passenger Barge, Tank Barge, Freight Barge, etc.)</i>
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetVesselSummary $parameters
     * @return \StructType\GetVesselSummaryResponse|bool
     */
    public function getVesselSummary(\StructType\GetVesselSummary $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getVesselSummary($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getVesselDocuments
     * Meta information extracted from the WSDL
     * - documentation: Returns:<ul><li>VesselID(Integer): Vessel Identification Number<li>TypeLookupName(String): Document Type<li>IssueDtTm(String): Issued Date<li>ExpiredDtTm(String): Expiration Date<li>OrganizationAbbr(String): Issuing Agency</ul>
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetVesselDocuments $parameters
     * @return \StructType\GetVesselDocumentsResponse|bool
     */
    public function getVesselDocuments(\StructType\GetVesselDocuments $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getVesselDocuments($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getOperationControls
     * Meta information extracted from the WSDL
     * - documentation: Returns:<ul><li>ActivityID(Integer): Activity Identification Number<li>ImposedDtTm(DateTime): Date Operational Control was Imposed<li>RemovedDtTm(DateTime): Date Operational Control was Removed<li>CategoryLookupName(String):
     * Operational Control Category<li>ReasonLookupName(String): Reason for Imposing Operational Control<li>UnitName(String): Imposing CG Unit<li>TypeLookupName(String): Type of Operation Control Imposed</ul>
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetOperationControls $parameters
     * @return \StructType\GetOperationControlsResponse|bool
     */
    public function getOperationControls(\StructType\GetOperationControls $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getOperationControls($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getVesselParticulars
     * Meta information extracted from the WSDL
     * - documentation: Returns:<ul><li>VesselName(String): Vessel Name<li>VesselCallSign(String): Vessel Call Sign<li>CountryLookupName(String): Vessel Flag<li>ServiceType(String): Vessel Service Type<li>ServiceSubType(String): Vessel Service Sub
     * Type<li>CargoAuthorizationDescription(String): Vessel Cargo Authority Description<li>ConstructionCompletedYear(String): Vessel Build Year<li>StatusLookupName(String): Vessel Service Status<li>OutOfServiceDate(DateTime): Out of Service Date - If
     * Applicable<li>VIN(String): Vessel Identification Number<li>IdentificationTypeLookupName(String): Identification Type</ul>
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetVesselParticulars $parameters
     * @return \StructType\GetVesselParticularsResponse|bool
     */
    public function getVesselParticulars(\StructType\GetVesselParticulars $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getVesselParticulars($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getVesselDimensions
     * Meta information extracted from the WSDL
     * - documentation: Returns:<ul><li>VesselID(Integer): Vessel Identification Number<li>DimensionTypeLookupId(Integer): Dimension Type Id<li>DimensionTypeLookupName(String): Dimension Type<li>BreadthInFeet(Decimal): Breadth<li>DepthInFeet(Decimal):
     * Depth<li>LengthInFeet(Decimal): Length</ul>
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetVesselDimensions $parameters
     * @return \StructType\GetVesselDimensionsResponse|bool
     */
    public function getVesselDimensions(\StructType\GetVesselDimensions $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getVesselDimensions($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getVesselTonnage
     * Meta information extracted from the WSDL
     * - documentation: Returns:<ul><li>VesselID(Integer): Vessel Identification Number<li>MeasureOfWeight(Integer): Weight<li>UnitOfMeasureLookupName(String): Weight Type<li>TonnageTypeLookupName(String): Tonnage Type</ul>
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetVesselTonnage $parameters
     * @return \StructType\GetVesselTonnageResponse|bool
     */
    public function getVesselTonnage(\StructType\GetVesselTonnage $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getVesselTonnage($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getVesselCases
     * Meta information extracted from the WSDL
     * - documentation: Returns:<ul><li>ActivityID(Integer): Activity Identification Number<li>VesselId(Integer): Vessel Identification Number<li>USCGZonePort(String): Port<li>StartDtTm(String): Incident Start Date<li>TypeLookupName(String): Activity Type
     * Description<li>ProcessStatusTypeLookupName(String): Case Status<li>ProcessStatusSubTypeLookupName(String): Case Sub-Status</ul>
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetVesselCases $parameters
     * @return \StructType\GetVesselCasesResponse|bool
     */
    public function getVesselCases(\StructType\GetVesselCases $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getVesselCases($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getVesselDeficiencies
     * Meta information extracted from the WSDL
     * - documentation: Returns:<ul><li>VesselID(Integer): Vessel Identification Number<li>ActivityNumber(Integer): Activity Identification Number <li>System(String): System<li>Description(String): Deficiency Description<li>FailureCauseLookupName(String):
     * Cause of the Deficiency<li>IsResolved(Boolean): Resolved Indicator<li>ResolutionDtTm(DateTime): Date the Deficiency Was Resolved<li>ResolutionDueDtTm(String): Date To Be Resolved By<li>ResolutionDescription(String): Description of the
     * resolution<li>SystemLookupName(String): System Involved<li>SubSystemLookupName(String): Sub-System Involved</ul>
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetVesselDeficiencies $parameters
     * @return \StructType\GetVesselDeficienciesResponse|bool
     */
    public function getVesselDeficiencies(\StructType\GetVesselDeficiencies $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getVesselDeficiencies($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getVesselSummaryXMLString
     * Meta information extracted from the WSDL
     * - documentation: Returns:<ul><li>VesselID(Integer): Vessel Identification Number<li>VesselName(String): Vessel Name<li>Identification(String): Primary Vessel Identification Number<li>HIN(String): Hull Identification Number<li>VesselCallSign(String):
     * Vessel Call Sign<li>StatusLookupName(String): Vessel Status<li>OutOfServiceDate(DateTime): Out of Service Date - If Applicable<li>ServiceType(String): Vessel Service<li>CountryLookupName(String): Vessel Flag<li>ConstructionCompletedYear(Integer):
     * Year Vessel Was Built</ul><br/><br/><i>The following strings may be used for Vessel Service type searches:</i><br/>- Commercial Fishing Vessel<br/>- Fish Processing Vessel<br/>- Freight Barge<br/>- Freight Ship<br/>- Industrial Vessel<br/>- Mobile
     * Offshore Drilling Unit<br/>- Offshore Supply Vessel<br/>- Oil Recovery<br/>- Passenger (Inspected)<br/>- Passenger (Uninspected)<br/>- Passenger Barge (Inspected)<br/>- Passenger Barge (Uninspected)<br/>- Public Freight<br/>- Public
     * Tankship/Barge<br/>- Public Vessel, Unclassified<br/>- Recreational<br/>- Research Vessel<br/>- School Ship<br/>- Tank Barge<br/>- Tank Ship<br/>- Towing Vessel<br/>- Unclassified<br/>- Unknown<br/>- ALL<br/><br/><i>This procedure also accepts wild
     * cards for Vessel Service. A search for 'Barge' will return all barges (i.e. Passenger Barge, Tank Barge, Freight Barge, etc.)</i>
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetVesselSummaryXMLString $parameters
     * @return \StructType\GetVesselSummaryXMLStringResponse|bool
     */
    public function getVesselSummaryXMLString(\StructType\GetVesselSummaryXMLString $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getVesselSummaryXMLString($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getVesselDocumentsXMLString
     * Meta information extracted from the WSDL
     * - documentation: Returns:<ul><li>VesselID(Integer): Vessel Identification Number<li>TypeLookupName(String): Document Type<li>IssueDtTm(String): Issued Date<li>ExpiredDtTm(String): Expiration Date<li>OrganizationAbbr(String): Issuing Agency</ul>
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetVesselDocumentsXMLString $parameters
     * @return \StructType\GetVesselDocumentsXMLStringResponse|bool
     */
    public function getVesselDocumentsXMLString(\StructType\GetVesselDocumentsXMLString $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getVesselDocumentsXMLString($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getOperationControlsXMLString
     * Meta information extracted from the WSDL
     * - documentation: Returns:<ul><li>ActivityID(Integer): Activity Identification Number<li>ImposedDtTm(DateTime): Date Operational Control was Imposed<li>RemovedDtTm(DateTime): Date Operational Control was Removed<li>CategoryLookupName(String):
     * Operational Control Category<li>ReasonLookupName(String): Reason for Imposing Operational Control<li>UnitName(String): Imposing CG Unit<li>TypeLookupName(String): Type of Operation Control Imposed</ul>
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetOperationControlsXMLString $parameters
     * @return \StructType\GetOperationControlsXMLStringResponse|bool
     */
    public function getOperationControlsXMLString(\StructType\GetOperationControlsXMLString $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getOperationControlsXMLString($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getVesselParticularsXMLString
     * Meta information extracted from the WSDL
     * - documentation: Returns:<ul><li>VesselName(String): Vessel Name<li>VesselCallSign(String): Vessel Call Sign<li>CountryLookupName(String): Vessel Flag<li>ServiceType(String): Vessel Service Type<li>ServiceSubType(String): Vessel Service Sub
     * Type<li>CargoAuthorizationDescription(String): Vessel Cargo Authority Description<li>ConstructionCompletedYear(String): Vessel Build Year<li>StatusLookupName(String): Vessel Service Status<li>OutOfServiceDate(DateTime): Out of Service Date - If
     * Applicable<li>VIN(String): Vessel Identification Number<li>IdentificationTypeLookupName(String): Identification Type</ul>
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetVesselParticularsXMLString $parameters
     * @return \StructType\GetVesselParticularsXMLStringResponse|bool
     */
    public function getVesselParticularsXMLString(\StructType\GetVesselParticularsXMLString $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getVesselParticularsXMLString($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getVesselDimensionsXMLString
     * Meta information extracted from the WSDL
     * - documentation: Returns:<ul><li>VesselID(Integer): Vessel Identification Number<li>DimensionTypeLookupId(Integer): Dimension Type Id<li>DimensionTypeLookupName(String): Dimension Type<li>BreadthInFeet(Decimal): Breadth<li>DepthInFeet(Decimal):
     * Depth<li>LengthInFeet(Decimal): Length</ul>
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetVesselDimensionsXMLString $parameters
     * @return \StructType\GetVesselDimensionsXMLStringResponse|bool
     */
    public function getVesselDimensionsXMLString(\StructType\GetVesselDimensionsXMLString $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getVesselDimensionsXMLString($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getVesselTonnageXMLString
     * Meta information extracted from the WSDL
     * - documentation: Returns:<ul><li>VesselID(Integer): Vessel Identification Number<li>MeasureOfWeight(Integer): Weight<li>UnitOfMeasureLookupName(String): Weight Type<li>TonnageTypeLookupName(String): Tonnage Type</ul>
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetVesselTonnageXMLString $parameters
     * @return \StructType\GetVesselTonnageXMLStringResponse|bool
     */
    public function getVesselTonnageXMLString(\StructType\GetVesselTonnageXMLString $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getVesselTonnageXMLString($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getVesselCasesXMLString
     * Meta information extracted from the WSDL
     * - documentation: Returns:<ul><li>ActivityID(Integer): Activity Identification Number<li>VesselId(Integer): Vessel Identification Number<li>USCGZonePort(String): Port<li>StartDtTm(String): Incident Start Date<li>TypeLookupName(String): Activity Type
     * Description<li>ProcessStatusTypeLookupName(String): Case Status<li>ProcessStatusSubTypeLookupName(String): Case Sub-Status</ul>
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetVesselCasesXMLString $parameters
     * @return \StructType\GetVesselCasesXMLStringResponse|bool
     */
    public function getVesselCasesXMLString(\StructType\GetVesselCasesXMLString $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getVesselCasesXMLString($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getVesselDeficienciesXMLString
     * Meta information extracted from the WSDL
     * - documentation: Returns:<ul><li>VesselID(Integer): Vessel Identification Number<li>ActivityNumber(Integer): Activity Identification Number <li>System(String): System<li>Description(String): Deficiency Description<li>FailureCauseLookupName(String):
     * Cause of the Deficiency<li>IsResolved(Boolean): Resolved Indicator<li>ResolutionDtTm(DateTime): Date the Deficiency Was Resolved<li>ResolutionDueDtTm(String): Date To Be Resolved By<li>ResolutionDescription(String): Description of the
     * resolution<li>SystemLookupName(String): System Involved<li>SubSystemLookupName(String): Sub-System Involved</ul>
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetVesselDeficienciesXMLString $parameters
     * @return \StructType\GetVesselDeficienciesXMLStringResponse|bool
     */
    public function getVesselDeficienciesXMLString(\StructType\GetVesselDeficienciesXMLString $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getVesselDeficienciesXMLString($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetOperationControlsResponse|\StructType\GetOperationControlsXMLStringResponse|\StructType\GetVesselCasesResponse|\StructType\GetVesselCasesXMLStringResponse|\StructType\GetVesselDeficienciesResponse|\StructType\GetVesselDeficienciesXMLStringResponse|\StructType\GetVesselDimensionsResponse|\StructType\GetVesselDimensionsXMLStringResponse|\StructType\GetVesselDocumentsResponse|\StructType\GetVesselDocumentsXMLStringResponse|\StructType\GetVesselParticularsResponse|\StructType\GetVesselParticularsXMLStringResponse|\StructType\GetVesselSummaryResponse|\StructType\GetVesselSummaryXMLStringResponse|\StructType\GetVesselTonnageResponse|\StructType\GetVesselTonnageXMLStringResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
