<?php

namespace Chronopost;

/**
 * Class which returns the class map definition
 * @package
 */
class ClassMap
{
    /**
     * Returns the mapping between the WSDL Structs and generated Structs' classes
     * This array is sent to the \SoapClient when calling the WS
     * @return string[]
     */
    final public static function get()
    {
        return array(
            'shipperValue' => '\\Chronopost\\StructType\\ShipperValue',
            'resultFaisabiliteESD' => '\\Chronopost\\StructType\\ResultFaisabiliteESD',
            'esdValue' => '\\Chronopost\\StructType\\EsdValue',
            'headerValue' => '\\Chronopost\\StructType\\HeaderValue',
            'customerValue' => '\\Chronopost\\StructType\\CustomerValue',
            'recipientValue' => '\\Chronopost\\StructType\\RecipientValue',
            'refValue' => '\\Chronopost\\StructType\\RefValue',
            'skybillValue' => '\\Chronopost\\StructType\\SkybillValue',
            'skybillParamsValue' => '\\Chronopost\\StructType\\SkybillParamsValue',
            'resultExpeditionValue' => '\\Chronopost\\StructType\\ResultExpeditionValue',
            'resultGetReservedSkybillWithTypeValue' => '\\Chronopost\\StructType\\ResultGetReservedSkybillWithTypeValue',
            'donneurDOrdre' => '\\Chronopost\\StructType\\DonneurDOrdre',
            'adresseEnlevement' => '\\Chronopost\\StructType\\AdresseEnlevement',
            'adresseEnlevementV2' => '\\Chronopost\\StructType\\AdresseEnlevementV2',
            'adresseEnlevementV3' => '\\Chronopost\\StructType\\AdresseEnlevementV3',
            'particularitesEsd' => '\\Chronopost\\StructType\\ParticularitesEsd',
            'options' => '\\Chronopost\\StructType\\Options',
            'resultEnlevementNational' => '\\Chronopost\\StructType\\ResultEnlevementNational',
            'infoEnlevement' => '\\Chronopost\\StructType\\InfoEnlevement',
            'scheduledValue' => '\\Chronopost\\StructType\\ScheduledValue',
            'appointmentValue' => '\\Chronopost\\StructType\\AppointmentValue',
            'esdWithRefClientValue' => '\\Chronopost\\StructType\\EsdWithRefClientValue',
            'esdWithRefClientValueV2' => '\\Chronopost\\StructType\\EsdWithRefClientValueV2',
            'resultReservationExpeditionValue' => '\\Chronopost\\StructType\\ResultReservationExpeditionValue',
            'esdValue3' => '\\Chronopost\\StructType\\EsdValue3',
            'skybillWithDimensionsValue' => '\\Chronopost\\StructType\\SkybillWithDimensionsValue',
            'skybillWithDimensionsValueV2' => '\\Chronopost\\StructType\\SkybillWithDimensionsValueV2',
            'skybillWithDimensionsValueV3' => '\\Chronopost\\StructType\\SkybillWithDimensionsValueV3',
            'skybillParamsValueV2' => '\\Chronopost\\StructType\\SkybillParamsValueV2',
            'resultShippingValue' => '\\Chronopost\\StructType\\ResultShippingValue',
            'resultMultiParcelExpeditionValue' => '\\Chronopost\\StructType\\ResultMultiParcelExpeditionValue',
            'resultMultiParcelValue' => '\\Chronopost\\StructType\\ResultMultiParcelValue',
            'skybillValueV2' => '\\Chronopost\\StructType\\SkybillValueV2',
            'resultReservationExpeditionValueV2' => '\\Chronopost\\StructType\\ResultReservationExpeditionValueV2',
            'resultGetReservedSkybillValue' => '\\Chronopost\\StructType\\ResultGetReservedSkybillValue',
            'resultReservationMultiParcelExpeditionValue' => '\\Chronopost\\StructType\\ResultReservationMultiParcelExpeditionValue',
            'resultParcelValue' => '\\Chronopost\\StructType\\ResultParcelValue',
            'shipperValueV2' => '\\Chronopost\\StructType\\ShipperValueV2',
            'recipientValueV2' => '\\Chronopost\\StructType\\RecipientValueV2',
            'refValueV2' => '\\Chronopost\\StructType\\RefValueV2',
            'skybillWithDimensionsValueV4' => '\\Chronopost\\StructType\\SkybillWithDimensionsValueV4',
            'skybillWithDimensionsValueV5' => '\\Chronopost\\StructType\\SkybillWithDimensionsValueV5',
            'skybillWithDimensionsValueV6' => '\\Chronopost\\StructType\\SkybillWithDimensionsValueV6',
            'recipientLocalValue' => '\\Chronopost\\StructType\\RecipientLocalValue',
            'recipientLocalValueV2' => '\\Chronopost\\StructType\\RecipientLocalValueV2',
            'customsValue' => '\\Chronopost\\StructType\\CustomsValue',
            'articleValue' => '\\Chronopost\\StructType\\ArticleValue',
            'headerValueV2' => '\\Chronopost\\StructType\\HeaderValueV2',
            'resultReservationMultiParcelExpeditionValueV2' => '\\Chronopost\\StructType\\ResultReservationMultiParcelExpeditionValueV2',
            'resultExpeditionValueV3' => '\\Chronopost\\StructType\\ResultExpeditionValueV3',
            'resultMonoParcelExpeditionValue' => '\\Chronopost\\StructType\\ResultMonoParcelExpeditionValue',
            'esdResultContraintesAgenceValue' => '\\Chronopost\\StructType\\EsdResultContraintesAgenceValue',
            'esdContraintesAgence' => '\\Chronopost\\StructType\\EsdContraintesAgence',
            'resultAnnulerEnlevement' => '\\Chronopost\\StructType\\ResultAnnulerEnlevement',
            'statut' => '\\Chronopost\\StructType\\Statut',
            'entry' => '\\Chronopost\\StructType\\Entry',
            'destinatairesDpd' => '\\Chronopost\\StructType\\DestinatairesDpd',
            'destinataireDpd' => '\\Chronopost\\StructType\\DestinataireDpd',
            'adresseDestinataire' => '\\Chronopost\\StructType\\AdresseDestinataire',
            'infoClient' => '\\Chronopost\\StructType\\InfoClient',
            'particularites' => '\\Chronopost\\StructType\\Particularites',
            'particularitesColisDpd' => '\\Chronopost\\StructType\\ParticularitesColisDpd',
            'infoDouanieres' => '\\Chronopost\\StructType\\InfoDouanieres',
            'resultPickupOrCollectionRequest' => '\\Chronopost\\StructType\\ResultPickupOrCollectionRequest',
            'skybillValueBase' => '\\Chronopost\\StructType\\SkybillValueBase',
            'resultShippingInfo' => '\\Chronopost\\StructType\\ResultShippingInfo',
            'error' => '\\Chronopost\\StructType\\Error',
            'detail' => '\\Chronopost\\StructType\\Detail',
            'shippingInfo' => '\\Chronopost\\StructType\\ShippingInfo',
            'resultGetRouting' => '\\Chronopost\\StructType\\ResultGetRouting',
            'geopostResult' => '\\Chronopost\\StructType\\GeopostResult',
            'faisabiliteESD' => '\\Chronopost\\StructType\\FaisabiliteESD',
            'faisabiliteESDResponse' => '\\Chronopost\\StructType\\FaisabiliteESDResponse',
            'shippingV2' => '\\Chronopost\\StructType\\ShippingV2',
            'shippingV2Response' => '\\Chronopost\\StructType\\ShippingV2Response',
            'getReservedSkybillWithTypeAndModeAuth' => '\\Chronopost\\StructType\\GetReservedSkybillWithTypeAndModeAuth',
            'getReservedSkybillWithTypeAndModeAuthResponse' => '\\Chronopost\\StructType\\GetReservedSkybillWithTypeAndModeAuthResponse',
            'getReservedSkybillWithType' => '\\Chronopost\\StructType\\GetReservedSkybillWithType',
            'getReservedSkybillWithTypeResponse' => '\\Chronopost\\StructType\\GetReservedSkybillWithTypeResponse',
            'creerEnlevementNational' => '\\Chronopost\\StructType\\CreerEnlevementNational',
            'creerEnlevementNationalResponse' => '\\Chronopost\\StructType\\CreerEnlevementNationalResponse',
            'shippingV3' => '\\Chronopost\\StructType\\ShippingV3',
            'shippingV3Response' => '\\Chronopost\\StructType\\ShippingV3Response',
            'getReservedSkybillWithTypeAndModeByReservation' => '\\Chronopost\\StructType\\GetReservedSkybillWithTypeAndModeByReservation',
            'getReservedSkybillWithTypeAndModeByReservationResponse' => '\\Chronopost\\StructType\\GetReservedSkybillWithTypeAndModeByReservationResponse',
            'shippingWithESDOnlyV2' => '\\Chronopost\\StructType\\ShippingWithESDOnlyV2',
            'shippingWithESDOnlyV2Response' => '\\Chronopost\\StructType\\ShippingWithESDOnlyV2Response',
            'shippingMultiParcel' => '\\Chronopost\\StructType\\ShippingMultiParcel',
            'shippingMultiParcelResponse' => '\\Chronopost\\StructType\\ShippingMultiParcelResponse',
            'shippingWithReservationV2' => '\\Chronopost\\StructType\\ShippingWithReservationV2',
            'shippingWithReservationV2Response' => '\\Chronopost\\StructType\\ShippingWithReservationV2Response',
            'shipping' => '\\Chronopost\\StructType\\Shipping',
            'shippingResponse' => '\\Chronopost\\StructType\\ShippingResponse',
            'getReservedSkybill' => '\\Chronopost\\StructType\\GetReservedSkybill',
            'getReservedSkybillResponse' => '\\Chronopost\\StructType\\GetReservedSkybillResponse',
            'shippingMultiParcelWithReservation' => '\\Chronopost\\StructType\\ShippingMultiParcelWithReservation',
            'shippingMultiParcelWithReservationResponse' => '\\Chronopost\\StructType\\ShippingMultiParcelWithReservationResponse',
            'shippingMultiParcelV4' => '\\Chronopost\\StructType\\ShippingMultiParcelV4',
            'shippingMultiParcelV4Response' => '\\Chronopost\\StructType\\ShippingMultiParcelV4Response',
            'shippingMultiParcelV5' => '\\Chronopost\\StructType\\ShippingMultiParcelV5',
            'shippingMultiParcelV5Response' => '\\Chronopost\\StructType\\ShippingMultiParcelV5Response',
            'shippingMultiParcelWithReservationV3' => '\\Chronopost\\StructType\\ShippingMultiParcelWithReservationV3',
            'shippingMultiParcelWithReservationV3Response' => '\\Chronopost\\StructType\\ShippingMultiParcelWithReservationV3Response',
            'shippingMultiParcelV2' => '\\Chronopost\\StructType\\ShippingMultiParcelV2',
            'shippingMultiParcelV2Response' => '\\Chronopost\\StructType\\ShippingMultiParcelV2Response',
            'shippingV6' => '\\Chronopost\\StructType\\ShippingV6',
            'shippingV6Response' => '\\Chronopost\\StructType\\ShippingV6Response',
            'shippingWithReservation' => '\\Chronopost\\StructType\\ShippingWithReservation',
            'shippingWithReservationResponse' => '\\Chronopost\\StructType\\ShippingWithReservationResponse',
            'shippingV7' => '\\Chronopost\\StructType\\ShippingV7',
            'shippingV7Response' => '\\Chronopost\\StructType\\ShippingV7Response',
            'rechercherContraintesEnlevement' => '\\Chronopost\\StructType\\RechercherContraintesEnlevement',
            'rechercherContraintesEnlevementResponse' => '\\Chronopost\\StructType\\RechercherContraintesEnlevementResponse',
            'annulerEnlevements' => '\\Chronopost\\StructType\\AnnulerEnlevements',
            'annulerEnlevementsResponse' => '\\Chronopost\\StructType\\AnnulerEnlevementsResponse',
            'creerEnlevementEurope' => '\\Chronopost\\StructType\\CreerEnlevementEurope',
            'creerEnlevementEuropeResponse' => '\\Chronopost\\StructType\\CreerEnlevementEuropeResponse',
            'shippingWithReservationAndESDWithRefClient' => '\\Chronopost\\StructType\\ShippingWithReservationAndESDWithRefClient',
            'shippingWithReservationAndESDWithRefClientResponse' => '\\Chronopost\\StructType\\ShippingWithReservationAndESDWithRefClientResponse',
            'getReservedSkybillWithTypeAndMode' => '\\Chronopost\\StructType\\GetReservedSkybillWithTypeAndMode',
            'getReservedSkybillWithTypeAndModeResponse' => '\\Chronopost\\StructType\\GetReservedSkybillWithTypeAndModeResponse',
            'shippingV4' => '\\Chronopost\\StructType\\ShippingV4',
            'shippingV4Response' => '\\Chronopost\\StructType\\ShippingV4Response',
            'shippingWithReservationAndESDWithRefClientPC' => '\\Chronopost\\StructType\\ShippingWithReservationAndESDWithRefClientPC',
            'shippingWithReservationAndESDWithRefClientPCResponse' => '\\Chronopost\\StructType\\ShippingWithReservationAndESDWithRefClientPCResponse',
            'shippingV5' => '\\Chronopost\\StructType\\ShippingV5',
            'shippingV5Response' => '\\Chronopost\\StructType\\ShippingV5Response',
            'shippingMultiParcelWithReservationV2' => '\\Chronopost\\StructType\\ShippingMultiParcelWithReservationV2',
            'shippingMultiParcelWithReservationV2Response' => '\\Chronopost\\StructType\\ShippingMultiParcelWithReservationV2Response',
            'shippingWithESDOnly' => '\\Chronopost\\StructType\\ShippingWithESDOnly',
            'shippingWithESDOnlyResponse' => '\\Chronopost\\StructType\\ShippingWithESDOnlyResponse',
            'getShippingInformation' => '\\Chronopost\\StructType\\GetShippingInformation',
            'getShippingInformationResponse' => '\\Chronopost\\StructType\\GetShippingInformationResponse',
            'getRouting' => '\\Chronopost\\StructType\\GetRouting',
            'getRoutingResponse' => '\\Chronopost\\StructType\\GetRoutingResponse',
            'shippingMultiParcelV3' => '\\Chronopost\\StructType\\ShippingMultiParcelV3',
            'shippingMultiParcelV3Response' => '\\Chronopost\\StructType\\ShippingMultiParcelV3Response',
        );
    }
}
