<?php

namespace Chronopost\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for resultAnnulerEnlevementV2 StructType
 * @subpackage Structs
 */
class ResultAnnulerEnlevementV2 extends AbstractStructBase
{
    /**
     * The codeErreur
     * @var int
     */
    public $codeErreur;
    /**
     * The errorMessage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $errorMessage;
    /**
     * The statut
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Chronopost\StructType\EsdCancelStatutValue[]
     */
    public $statut;
    /**
     * Constructor method for resultAnnulerEnlevementV2
     * @uses ResultAnnulerEnlevementV2::setCodeErreur()
     * @uses ResultAnnulerEnlevementV2::setErrorMessage()
     * @uses ResultAnnulerEnlevementV2::setStatut()
     * @param int $codeErreur
     * @param string $errorMessage
     * @param \Chronopost\StructType\EsdCancelStatutValue[] $statut
     */
    public function __construct($codeErreur = null, $errorMessage = null, array $statut = array())
    {
        $this
            ->setCodeErreur($codeErreur)
            ->setErrorMessage($errorMessage)
            ->setStatut($statut);
    }
    /**
     * Get codeErreur value
     * @return int|null
     */
    public function getCodeErreur()
    {
        return $this->codeErreur;
    }
    /**
     * Set codeErreur value
     * @param int $codeErreur
     * @return \Chronopost\StructType\ResultAnnulerEnlevementV2
     */
    public function setCodeErreur($codeErreur = null)
    {
        // validation for constraint: int
        if (!is_null($codeErreur) && !(is_int($codeErreur) || ctype_digit($codeErreur))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($codeErreur, true), gettype($codeErreur)), __LINE__);
        }
        $this->codeErreur = $codeErreur;
        return $this;
    }
    /**
     * Get errorMessage value
     * @return string|null
     */
    public function getErrorMessage()
    {
        return $this->errorMessage;
    }
    /**
     * Set errorMessage value
     * @param string $errorMessage
     * @return \Chronopost\StructType\ResultAnnulerEnlevementV2
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorMessage, true), gettype($errorMessage)), __LINE__);
        }
        $this->errorMessage = $errorMessage;
        return $this;
    }
    /**
     * Get statut value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Chronopost\StructType\EsdCancelStatutValue[]|null
     */
    public function getStatut()
    {
        return isset($this->statut) ? $this->statut : null;
    }
    /**
     * This method is responsible for validating the values passed to the setStatut method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStatut method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStatutForArrayConstraintsFromSetStatut(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $resultAnnulerEnlevementV2StatutItem) {
            // validation for constraint: itemType
            if (!$resultAnnulerEnlevementV2StatutItem instanceof \Chronopost\StructType\EsdCancelStatutValue) {
                $invalidValues[] = is_object($resultAnnulerEnlevementV2StatutItem) ? get_class($resultAnnulerEnlevementV2StatutItem) : sprintf('%s(%s)', gettype($resultAnnulerEnlevementV2StatutItem), var_export($resultAnnulerEnlevementV2StatutItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The statut property can only contain items of type \Chronopost\StructType\EsdCancelStatutValue, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set statut value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \Chronopost\StructType\EsdCancelStatutValue[] $statut
     * @return \Chronopost\StructType\ResultAnnulerEnlevementV2
     */
    public function setStatut(array $statut = array())
    {
        // validation for constraint: array
        if ('' !== ($statutArrayErrorMessage = self::validateStatutForArrayConstraintsFromSetStatut($statut))) {
            throw new \InvalidArgumentException($statutArrayErrorMessage, __LINE__);
        }
        if (is_null($statut) || (is_array($statut) && empty($statut))) {
            unset($this->statut);
        } else {
            $this->statut = $statut;
        }
        return $this;
    }
    /**
     * Add item to statut value
     * @throws \InvalidArgumentException
     * @param \Chronopost\StructType\EsdCancelStatutValue $item
     * @return \Chronopost\StructType\ResultAnnulerEnlevementV2
     */
    public function addToStatut(\Chronopost\StructType\EsdCancelStatutValue $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Chronopost\StructType\EsdCancelStatutValue) {
            throw new \InvalidArgumentException(sprintf('The statut property can only contain items of type \Chronopost\StructType\EsdCancelStatutValue, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->statut[] = $item;
        return $this;
    }
}
