<?php

namespace Chronopost\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for annulerEnlevementsV2 StructType
 * @subpackage Structs
 */
class AnnulerEnlevementsV2 extends AbstractStructBase
{
    /**
     * The accountNumber
     * @var string
     */
    public $accountNumber;
    /**
     * The password
     * @var string
     */
    public $password;
    /**
     * The locale
     * @var string
     */
    public $locale;
    /**
     * The esdNumber
     * @var string
     */
    public $esdNumber;
    /**
     * The version
     * @var string
     */
    public $version;
    /**
     * Constructor method for annulerEnlevementsV2
     * @uses AnnulerEnlevementsV2::setAccountNumber()
     * @uses AnnulerEnlevementsV2::setPassword()
     * @uses AnnulerEnlevementsV2::setLocale()
     * @uses AnnulerEnlevementsV2::setEsdNumber()
     * @uses AnnulerEnlevementsV2::setVersion()
     * @param string $accountNumber
     * @param string $password
     * @param string $locale
     * @param string $esdNumber
     * @param string $version
     */
    public function __construct($accountNumber = null, $password = null, $locale = null, $esdNumber = null, $version = null)
    {
        $this
            ->setAccountNumber($accountNumber)
            ->setPassword($password)
            ->setLocale($locale)
            ->setEsdNumber($esdNumber)
            ->setVersion($version);
    }
    /**
     * Get accountNumber value
     * @return string|null
     */
    public function getAccountNumber()
    {
        return $this->accountNumber;
    }
    /**
     * Set accountNumber value
     * @param string $accountNumber
     * @return \Chronopost\StructType\AnnulerEnlevementsV2
     */
    public function setAccountNumber($accountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($accountNumber) && !is_string($accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountNumber, true), gettype($accountNumber)), __LINE__);
        }
        $this->accountNumber = $accountNumber;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \Chronopost\StructType\AnnulerEnlevementsV2
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get locale value
     * @return string|null
     */
    public function getLocale()
    {
        return $this->locale;
    }
    /**
     * Set locale value
     * @param string $locale
     * @return \Chronopost\StructType\AnnulerEnlevementsV2
     */
    public function setLocale($locale = null)
    {
        // validation for constraint: string
        if (!is_null($locale) && !is_string($locale)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($locale, true), gettype($locale)), __LINE__);
        }
        $this->locale = $locale;
        return $this;
    }
    /**
     * Get esdNumber value
     * @return string|null
     */
    public function getEsdNumber()
    {
        return $this->esdNumber;
    }
    /**
     * Set esdNumber value
     * @param string $esdNumber
     * @return \Chronopost\StructType\AnnulerEnlevementsV2
     */
    public function setEsdNumber($esdNumber = null)
    {
        // validation for constraint: string
        if (!is_null($esdNumber) && !is_string($esdNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($esdNumber, true), gettype($esdNumber)), __LINE__);
        }
        $this->esdNumber = $esdNumber;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \Chronopost\StructType\AnnulerEnlevementsV2
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
