<?php

namespace Chronopost\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for resultAnnulerEnlevementV2 StructType
 * @subpackage Structs
 */
class ResultAnnulerEnlevementV2 extends AbstractStructBase
{
    /**
     * The codeErreur
     * @var int
     */
    public $codeErreur;
    /**
     * The errorMessage
     * @var string
     */
    public $errorMessage;
    /**
     * The statut
     * @var \Chronopost\StructType\EsdCancelStatutValue
     */
    public $statut;
    /**
     * Constructor method for resultAnnulerEnlevementV2
     * @uses ResultAnnulerEnlevementV2::setCodeErreur()
     * @uses ResultAnnulerEnlevementV2::setErrorMessage()
     * @uses ResultAnnulerEnlevementV2::setStatut()
     * @param int $codeErreur
     * @param string $errorMessage
     * @param \Chronopost\StructType\EsdCancelStatutValue $statut
     */
    public function __construct($codeErreur = null, $errorMessage = null, \Chronopost\StructType\EsdCancelStatutValue $statut = null)
    {
        $this
            ->setCodeErreur($codeErreur)
            ->setErrorMessage($errorMessage)
            ->setStatut($statut);
    }
    /**
     * Get codeErreur value
     * @return int|null
     */
    public function getCodeErreur()
    {
        return $this->codeErreur;
    }
    /**
     * Set codeErreur value
     * @param int $codeErreur
     * @return \Chronopost\StructType\ResultAnnulerEnlevementV2
     */
    public function setCodeErreur($codeErreur = null)
    {
        // validation for constraint: int
        if (!is_null($codeErreur) && !(is_int($codeErreur) || ctype_digit($codeErreur))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($codeErreur, true), gettype($codeErreur)), __LINE__);
        }
        $this->codeErreur = $codeErreur;
        return $this;
    }
    /**
     * Get errorMessage value
     * @return string|null
     */
    public function getErrorMessage()
    {
        return $this->errorMessage;
    }
    /**
     * Set errorMessage value
     * @param string $errorMessage
     * @return \Chronopost\StructType\ResultAnnulerEnlevementV2
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorMessage, true), gettype($errorMessage)), __LINE__);
        }
        $this->errorMessage = $errorMessage;
        return $this;
    }
    /**
     * Get statut value
     * @return \Chronopost\StructType\EsdCancelStatutValue|null
     */
    public function getStatut()
    {
        return $this->statut;
    }
    /**
     * Set statut value
     * @param \Chronopost\StructType\EsdCancelStatutValue $statut
     * @return \Chronopost\StructType\ResultAnnulerEnlevementV2
     */
    public function setStatut(\Chronopost\StructType\EsdCancelStatutValue $statut = null)
    {
        $this->statut = $statut;
        return $this;
    }
}
